/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.SpaceAttachments;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationAnalyticsService;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.impl.StatelessResults;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultAttachmentService
implements AttachmentService {
    private static final String CLOUD_ID = "cloudId";
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultAttachmentService.class);
    private final PluginTransactionTemplate ptx;
    private final AttachmentMigrationStore attachmentMigrationStore;
    private final AttachmentStore attachmentStore;
    private final AttachmentMigrationAnalyticsService attachmentMigrationAnalyticsService;
    private final Supplier<Instant> instantSupplier;
    private final V4Logger v4Logger;

    public DefaultAttachmentService(PluginTransactionTemplate ptx, AttachmentMigrationStore attachmentMigrationStore, AttachmentStore attachmentStore, AttachmentMigrationAnalyticsService attachmentMigrationAnalyticsService, V4Logger v4Logger) {
        this.ptx = ptx;
        this.attachmentMigrationStore = attachmentMigrationStore;
        this.attachmentStore = attachmentStore;
        this.attachmentMigrationAnalyticsService = attachmentMigrationAnalyticsService;
        this.v4Logger = v4Logger;
        this.instantSupplier = Instant::now;
    }

    @Override
    public SpaceAttachments getAttachmentsToMigrate(String migrationId, String spaceKey, CloudSite cloudSite, boolean excludeContentInTrash) {
        SpaceAttachments spaceAttachments;
        String cloudId = cloudSite.getCloudId();
        long attachmentsSizeToUpload = this.getAttachmentsToMigrateSize(cloudId, spaceKey, excludeContentInTrash);
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties(CLOUD_ID, cloudId, "spaceKey", spaceKey, "migrationId", migrationId);
        this.v4Logger.logInfo(log, logContext, String.format("Details of migrationSize to upload %d", attachmentsSizeToUpload));
        boolean success = true;
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            this.v4Logger.logInfo(log, logContext, "Starting to fetch attachments from db");
            this.attachmentMigrationAnalyticsService.buildAndSaveFetchAttachmentsStartEvent(migrationId, cloudId, spaceKey, attachmentsSizeToUpload);
            spaceAttachments = new SpaceAttachments(this.listAttachmentsToMigrate(cloudId, spaceKey, excludeContentInTrash), attachmentsSizeToUpload);
        }
        catch (Exception e) {
            try {
                this.v4Logger.logError(log, logContext, "Failed to fetch attachments from db", e);
                success = false;
                throw e;
            }
            catch (Throwable throwable) {
                logContext.addAdditionalProperties("success", success);
                this.v4Logger.logInfo(log, logContext, "Finished fetching attachments from db");
                this.attachmentMigrationAnalyticsService.buildAndSaveFetchAttachmentsEndEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, migrationId, cloudId, spaceKey, attachmentsSizeToUpload);
                throw throwable;
            }
        }
        logContext.addAdditionalProperties("success", success);
        this.v4Logger.logInfo(log, logContext, "Finished fetching attachments from db");
        this.attachmentMigrationAnalyticsService.buildAndSaveFetchAttachmentsEndEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, migrationId, cloudId, spaceKey, attachmentsSizeToUpload);
        return spaceAttachments;
    }

    @Override
    public void logSuccessfulAttachmentMigration(CloudSite cloudSite, Attachment attachment, String mediaId) {
        this.ptx.write(() -> this.updateAttachmentMigration(cloudSite.getCloudId(), attachment.getId(), mediaId, attachment.getVersion()));
    }

    @Override
    public void logFailedAttachmentMigration(CloudSite cloudSite, Attachment attachment) {
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("attachmentId", attachment.getId(), CLOUD_ID, cloudSite.getCloudId());
        this.v4Logger.logWarn(log, logContext, "Failed attachment migration");
        this.ptx.write(() -> this.updateAttachmentMigration(cloudSite.getCloudId(), attachment.getId(), null, attachment.getVersion()));
    }

    public void updateAttachmentMigration(String cloudId, long attachmentId, String mediaId, int attachmentVersion) {
        Optional<AttachmentMigration> attachmentMigrations = this.attachmentMigrationStore.findMigration(attachmentId, cloudId);
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("attachmentId", attachmentId, CLOUD_ID, cloudId, "mediaId", mediaId, "attachmentVersion", attachmentVersion);
        if (!attachmentMigrations.isPresent() || attachmentMigrations.get().getMediaId() == null || mediaId != null) {
            this.v4Logger.logInfo(log, logContext, "Updating attachment migration.");
            AttachmentMigration attachmentMigration = attachmentMigrations.isPresent() ? attachmentMigrations.get() : new AttachmentMigration();
            attachmentMigration.setCloudId(cloudId);
            attachmentMigration.setAttachmentId(attachmentId);
            attachmentMigration.setMediaId(mediaId);
            attachmentMigration.setVersion(attachmentVersion);
            this.attachmentMigrationStore.saveMigration(attachmentMigration);
        } else {
            this.v4Logger.logInfo(log, logContext, "No update required for attachment migration");
        }
    }

    @Override
    public int deleteAttachmentMigrationTrackingByCloudSite(CloudSite cloudSite) {
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties(CLOUD_ID, cloudSite.getCloudId());
        this.v4Logger.logInfo(log, logContext, "Deleting attachment migration");
        return this.ptx.write(() -> this.attachmentMigrationStore.deleteMigrationsByCloudId(cloudSite.getCloudId()));
    }

    @Override
    public SpaceAttachmentCount getAttachmentsCountInSpaceAndMigrated(String spaceKey, String cloudId, long spaceAttachmentCount) {
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("spaceKey", spaceKey, CLOUD_ID, cloudId, "spaceAttachmentCount", spaceAttachmentCount);
        this.v4Logger.logInfo(log, logContext, "Retrieving attachment count for space and migrated attachments");
        return this.ptx.read(() -> {
            long migAttachmentCount = this.attachmentMigrationStore.countRetrievedAttachmentMigrationsBySpaceKeyAndCloudId(spaceKey, cloudId);
            long unRetrievableAttachmentCount = this.attachmentMigrationStore.countUnRetrievableAttachmentMigrationsBySpaceKeyAndCloudId(spaceKey, cloudId);
            return new SpaceAttachmentCount(cloudId, spaceKey, spaceAttachmentCount, migAttachmentCount, unRetrievableAttachmentCount);
        });
    }

    @Override
    public long countAlreadyMigratedAttachmentsBySpaceKeyAndCloudId(String spaceKey, String cloudId) {
        return this.ptx.read(() -> this.attachmentMigrationStore.countAlreadyMigratedAttachmentsBySpaceKeyAndCloudId(spaceKey, cloudId));
    }

    @Override
    public long countAttachmentsInSpace(String spaceKey, boolean excludeContentInTrash) {
        return this.ptx.read(() -> this.attachmentStore.countAttachmentsBySpaceKey(spaceKey, excludeContentInTrash));
    }

    private StatelessResults<Attachment> listAttachmentsToMigrate(String cloudId, String spaceKey, boolean excludeContentInTrash) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrate(cloudId, spaceKey, excludeContentInTrash));
    }

    private long getAttachmentsToMigrateSize(String cloudId, String spaceKey, boolean excludeContentInTrash) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrateSize(cloudId, spaceKey, excludeContentInTrash));
    }
}

