/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.rest.AssessmentStatusDto;
import com.atlassian.migration.agent.rest.InstanceAssessmentResource;
import com.atlassian.migration.agent.rest.dto.StreamResponseSpec;
import com.atlassian.migration.agent.store.guardrails.AssessmentDuration;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="instance/assessment/job")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InstanceAssessmentResourceJakarta {
    private final InstanceAssessmentResource originalResource;

    @Inject
    public InstanceAssessmentResourceJakarta(InstanceAssessmentResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/schedule")
    public Response scheduleNewAssessment(@QueryParam(value="mode") @DefaultValue(value="DEFAULT") InstanceAssessmentResource.InstanceAssessmentMode mode) {
        AssessmentStatusDto result = this.originalResource.scheduleNewAssessmentDto(mode);
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/cancel")
    public Response cancelAssessment() {
        AssessmentStatusDto result = this.originalResource.cancelAssessmentDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/csv")
    public Response downloadCSV() {
        Pair<Integer, Object> result = this.originalResource.downloadCSVDto(false);
        return this.getResponse(result);
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/csv/example")
    public Response downloadExampleCSV() {
        Pair<Integer, Object> result = this.originalResource.downloadCSVDto(true);
        return this.getResponse(result);
    }

    @GET
    @Path(value="")
    public Response getJobProgress() {
        AssessmentStatusDto result = this.originalResource.getJobProgressDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/totalduration")
    public Response getTotalJobDuration(@QueryParam(value="mode") @DefaultValue(value="DEFAULT") InstanceAssessmentResource.InstanceAssessmentMode mode) {
        AssessmentDuration result = this.originalResource.getTotalJobDurationDto(mode);
        return Response.ok((Object)result).build();
    }

    private Response getResponse(Pair<Integer, Object> result) {
        int status = (Integer)result.getLeft();
        Object body = result.getRight();
        if (status != 200) {
            return Response.status((int)status).entity(body).build();
        }
        StreamResponseSpec spec = (StreamResponseSpec)body;
        StreamingOutput so = spec.writer::write;
        return Response.ok((Object)so).type(spec.contentType).header("Content-disposition", (Object)spec.contentDisposition).build();
    }
}

