/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.rest.dto.OutputStreamWriter;
import com.atlassian.migration.agent.rest.dto.StreamResponseSpec;
import com.atlassian.migration.agent.service.check.CheckResultCSVWriter;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.FailedChecksFileReportsManager;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.check.csv.AppVendorCheckCSVContainer;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nonnull;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Path(value="check")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CheckResource {
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResource.class);
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private final PreflightService preflightService;
    private final CheckResultsService checkResultService;
    private final FailedChecksFileReportsManager failedChecksFileReportsManager;

    @Inject
    public CheckResource(PreflightService preflightService, CheckResultsService checkResultService, FailedChecksFileReportsManager failedChecksFileReportsManager) {
        this.preflightService = preflightService;
        this.checkResultService = checkResultService;
        this.failedChecksFileReportsManager = failedChecksFileReportsManager;
    }

    @GET
    @Path(value="/{executionId}/status")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId) {
        Pair<Integer, Object> result = this.getCheckExecutionStatusDto(executionId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/{executionId}/status/{checkType}")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId, @PathParam(value="checkType") CheckType checkType) {
        Pair<Integer, Object> result = this.getCheckExecutionStatusDto(executionId, checkType);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{executionId}")
    public void executeChecks(@PathParam(value="executionId") String executionId, @QueryParam(value="type") Set<CheckType> types, PlanDto planDto) {
        this.executeChecksDto(executionId, types, planDto);
    }

    @POST
    @Path(value="/{executionId}/{checkType}")
    public void executeChecksForApp(@PathParam(value="executionId") String executionId, @PathParam(value="checkType") CheckType checkType, @QueryParam(value="appKey") @javax.annotation.Nonnull @Nonnull String serverAppKey, PlanDto planDto) {
        this.executeChecksForAppDto(executionId, checkType, serverAppKey, planDto);
    }

    @DELETE
    @Path(value="/{executionId}")
    public void deleteCheckExecutionResults(@PathParam(value="executionId") String executionId) {
        this.deleteCheckExecutionResultsDto(executionId);
    }

    @GET
    @Path(value="/{executionId}/{type}/csv")
    public Response generateCSV(@PathParam(value="executionId") String executionId, @PathParam(value="type") CheckType type, @QueryParam(value="planName") String planName) {
        Pair<Integer, Object> result = this.generateCSVDto(executionId, type, planName);
        return this.getResponse(result);
    }

    @GET
    @Path(value="/{executionId}/AppVendorCheck/{appKey}/{checkId}/csv")
    public Response generateAppVendorCheckCSV(@PathParam(value="executionId") String executionId, @PathParam(value="appKey") String appKey, @PathParam(value="checkId") String checkId) {
        Pair<Integer, Object> result = this.generateAppVendorCheckCSVDto(executionId, appKey, checkId);
        return this.getResponse(result);
    }

    public Pair<Integer, Object> getCheckExecutionStatusDto(String executionId) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            List<CheckResultDto> results = this.preflightService.getCheckExecutionStatus(executionId);
            if (results.isEmpty()) {
                log.warn("Check execution not found.");
                return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)new MessageDto(String.format("Check execution with id = %s not found", executionId)));
            }
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new ChecksResultDto(results));
        });
    }

    public Pair<Integer, Object> getCheckExecutionStatusDto(String executionId, CheckType checkType) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            List<CheckResultDto> results = this.preflightService.getCheckExecutionStatus(executionId, checkType);
            if (results.isEmpty()) {
                log.warn("Check execution not found.");
                return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)new MessageDto(String.format("Check execution with id = %s not found", executionId)));
            }
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new ChecksResultDto(results));
        });
    }

    public void executeChecksDto(String executionId, Set<CheckType> types, PlanDto planDto) {
        LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> this.preflightService.executeChecks(executionId, planDto, types));
    }

    public void executeChecksForAppDto(String executionId, CheckType checkType, String serverAppKey, PlanDto planDto) {
        LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> this.preflightService.executeChecksForApp(executionId, planDto, checkType, serverAppKey));
    }

    public void deleteCheckExecutionResultsDto(String executionId) {
        LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            this.checkResultService.deleteCheckResultsByExecutionId(executionId);
            log.info("Check execution is deleted.");
        });
    }

    public Pair<Integer, Object> generateCSVDto(String executionId, CheckType type, String planName) {
        if (!CheckType.checkTypesForCSV.contains(type)) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto(String.format("%s type is only allowed.", type.value())));
        }
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        CheckResultCSVContainer checkResultCSVContainer = this.preflightService.createCheckResultCSVContainer(executionId, type);
        String name = StringUtils.isNotEmpty((CharSequence)planName) ? planName : executionId;
        String contentDisposition = String.format("attachment; filename=\"%s\"; creation-date=\"%s\"", this.failedChecksFileReportsManager.generateFilename(name, type), DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
        OutputStreamWriter osw = out -> writer.writeResultsInStream(out, checkResultCSVContainer);
        StreamResponseSpec spec = new StreamResponseSpec(osw, TEXT_CSV, contentDisposition);
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)spec);
    }

    public Pair<Integer, Object> generateAppVendorCheckCSVDto(String executionId, String appKey, String checkId) {
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        Optional<AppVendorCheckCSVContainer> checkResultCSVContainer = this.preflightService.createAppVendorCheckResultCSVContainer(executionId, appKey, checkId);
        if (checkResultCSVContainer.isPresent()) {
            String contentDisposition = String.format("attachment; filename=\"%s\"; creation-date=\"%s\"", this.failedChecksFileReportsManager.generateAppVendorCSVFilename(executionId, appKey, checkId), DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
            OutputStreamWriter osw = out -> writer.writeListResultsInStream(out, ((AppVendorCheckCSVContainer)checkResultCSVContainer.get()).headers(), ((AppVendorCheckCSVContainer)checkResultCSVContainer.get()).beans());
            StreamResponseSpec spec = new StreamResponseSpec(osw, TEXT_CSV, contentDisposition);
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)spec);
        }
        log.warn("No Csv content for executionId: {} appKey: {} checkId: {} is empty", new Object[]{executionId, appKey, checkId});
        return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)new MessageDto(String.format("Csv content not found for executionId=%s appKey=%s checkId=%s", executionId, appKey, checkId)));
    }

    private Response getResponse(Pair<Integer, Object> result) {
        int status = (Integer)result.getLeft();
        Object body = result.getRight();
        if (status != Response.Status.OK.getStatusCode()) {
            return Response.status((int)status).entity(body).build();
        }
        StreamResponseSpec spec = (StreamResponseSpec)body;
        StreamingOutput so = spec.writer::write;
        return Response.ok((Object)so).type(spec.contentType).header(CONTENT_DISPOSITION, (Object)spec.contentDisposition).build();
    }
}

