/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.udc.common.model.usermapping.model.ErrorType;
import com.atlassian.migration.udc.common.model.usermapping.model.ProgressStatus;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCConfigAction;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingException;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingStatisticsDTO;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingUploadStatusDTO;
import com.atlassian.migration.udc.config.ConfigUpdateResult;
import com.atlassian.migration.udc.config.GlobalEmailFixesConfigService;
import com.atlassian.migration.udc.usermapping.UserMappingService;
import com.atlassian.migration.udc.usermapping.rest.SaveUserMappingConfig;
import com.atlassian.migration.udc.utils.CsvUtil;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Path(value="user-mapping")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CCMAUserMappingResourceJakarta {
    private static final String USER_MAPPING_CSV = "user-mapping.csv";
    private static final String USER_MAPPING_VALIDATION_ERRORS_CSV = "user-mapping-validation-errors.csv";
    private static final String TEXT_CSV = "text/csv";
    private static final String APPLICATION_ZIP = "application/zip";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private final UserMappingService userMappingService;
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;

    @Inject
    public CCMAUserMappingResourceJakarta(UserMappingService userMappingService, GlobalEmailFixesConfigService globalEmailFixesConfigService) {
        this.userMappingService = userMappingService;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
    }

    @GET
    @Path(value="/mappings")
    public Response getAllUserMappingsCsv() {
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        this.userMappingService.getAllUserMappings((OutputStream)inMemoryOutputStream);
        StreamingOutput so = inMemoryOutputStream::writeTo;
        return Response.ok((Object)so).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)String.format("attachment; filename=%s", USER_MAPPING_CSV)).build();
    }

    @GET
    @Path(value="/statistics")
    public Response getUserMappingStatistics() {
        UserMappingStatisticsDTO dto = UserMappingStatisticsDTO.Companion.from(this.userMappingService.getUserMappingStatistics());
        return Response.ok((Object)dto).build();
    }

    @PUT
    @Path(value="/config")
    public Response saveUserMappingConfig(SaveUserMappingConfig action) {
        UDCConfigAction resolved;
        String act = action != null ? action.getAction() : null;
        try {
            resolved = UDCConfigAction.valueOf((String)(act != null ? act.toUpperCase() : "unknown"));
        }
        catch (IllegalArgumentException ex) {
            String allowed = Arrays.toString(UDCConfigAction.values());
            String msg = action + " argument provided for action parameter is invalid.\nList of allowed parameters: " + allowed;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
        }
        ConfigUpdateResult result = this.globalEmailFixesConfigService.saveUserMappingConfigState(resolved);
        if (result instanceof ConfigUpdateResult.Success) {
            return Response.ok((Object)"User mapping config action executed").build();
        }
        if (result instanceof ConfigUpdateResult.MigrationIsRunningError) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Can't update config when a migration is running").build();
        }
        if (result instanceof ConfigUpdateResult.ValidationError) {
            String msg = ((ConfigUpdateResult.ValidationError)result).getErrorMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/config")
    public Response getUserMappingConfig() {
        return Response.ok((Object)this.globalEmailFixesConfigService.getUserMappingConfig()).build();
    }

    @POST
    @Path(value="/upload/{cloudId}")
    @Consumes(value={"application/octet-stream"})
    public Response uploadCsv(@PathParam(value="cloudId") String cloudId, @QueryParam(value="fileName") String fileName, InputStream inputStream) {
        if (!CsvUtil.INSTANCE.isCorrectCsvAttached(inputStream, fileName)) {
            return this.buildExceptionResponse(UserMappingException.Type.INVALID_FILE_TYPE, new ErrorEntity("INVALID_FILE_TYPE"));
        }
        try {
            this.userMappingService.scheduleCsvUploadJob(cloudId, inputStream, fileName);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UserMappingException) {
                UserMappingException userMappingException = (UserMappingException)e.getCause();
                return this.buildExceptionResponse(userMappingException.getType(), new ErrorEntity(userMappingException.getType().name()));
            }
            throw e;
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/upload/summary")
    public Response getUploadStatus() {
        ProgressStatus status = this.userMappingService.getUserMappingUploadStatus().getProgressStatus();
        if (status != ProgressStatus.FAILED) {
            return Response.ok((Object)new UserMappingUploadStatusDTO(status, null)).build();
        }
        ErrorType errorType = this.userMappingService.getUserMappingUploadStatus().getErrorType();
        UserMappingException.Type exceptionType = errorType == ErrorType.RECORD_VALIDATION_FAILED ? UserMappingException.Type.CSV_RECORD_VALIDATION_FAILED : (errorType == ErrorType.INVALID_USERS ? UserMappingException.Type.INVALID_USERS_FOUND : (errorType == ErrorType.UNKNOWN_USERS || errorType == ErrorType.UNFIXED_USERS || errorType == ErrorType.INCORRECT_USER_KEYS ? UserMappingException.Type.MISMATCHED_USERS : (errorType == ErrorType.NO_CHANGES ? UserMappingException.Type.CSV_NO_CHANGES : UserMappingException.Type.CSV_UPLOAD_FAILED)));
        return this.buildExceptionResponse(exceptionType, new UserMappingUploadStatusDTO(status, exceptionType.name()));
    }

    @GET
    @Path(value="upload/summary/invalid-emails")
    public Response getInvalidEmails() {
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        this.userMappingService.getValidationErrorsCsv(inMemoryOutputStream);
        StreamingOutput so = inMemoryOutputStream::writeTo;
        return Response.ok((Object)so).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)String.format("attachment; filename=%s", USER_MAPPING_VALIDATION_ERRORS_CSV)).build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/{cloudId}")
    public Response downloadZip(@PathParam(value="cloudId") String cloudId) {
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        try {
            this.userMappingService.buildSourceFileZip((OutputStream)inMemoryOutputStream, cloudId);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UserMappingException) {
                UserMappingException userMappingException = (UserMappingException)e.getCause();
                return this.buildExceptionResponse(userMappingException.getType(), new ErrorEntity(userMappingException.getType().name()));
            }
            throw e;
        }
        StreamingOutput so = inMemoryOutputStream::writeTo;
        return Response.ok((Object)so).type(APPLICATION_ZIP).header(CONTENT_DISPOSITION, (Object)"attachment; filename=user-mapping.zip").build();
    }

    @GET
    @Path(value="/download/availability")
    public Response getDownloadSourceFileStatus() {
        return Response.ok((Object)this.userMappingService.sourceFileAvailability()).build();
    }

    private Response buildExceptionResponse(UserMappingException.Type type, Object errorEntity) {
        Response.Status status;
        switch (type) {
            case USER_BASE_SCAN_NOT_FINISHED: 
            case FILE_DOES_NOT_EXIST: 
            case USER_MAPPING_UPLOAD_ALREADY_IN_PROGRESS: 
            case FILE_DOES_NOT_EXIST_RERUNNING_USERBASE_SCAN: 
            case INVALID_FILE_TYPE: 
            case CSV_RECORD_VALIDATION_FAILED: 
            case INVALID_USERS_FOUND: 
            case MISMATCHED_USERS: 
            case CSV_NO_CHANGES: {
                status = Response.Status.OK;
                break;
            }
            default: {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity(errorEntity).build();
    }

    public static class ErrorEntity {
        private final String error;

        public ErrorEntity(String error) {
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }
}

