/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.assessment.BrowserMetricsDto;
import com.atlassian.migration.agent.rest.BrowserMetricsCheckResponse;
import com.atlassian.migration.agent.rest.BrowserMetricsResource;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="browser-metrics")
@LicensedOnly
@Consumes(value={"application/json"})
public class BrowserMetricsResourceJakarta {
    private final BrowserMetricsResource originalResource;

    @Inject
    public BrowserMetricsResourceJakarta(BrowserMetricsResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public BrowserMetricsCheckResponse isBrowserMetricsEnabled() {
        return this.originalResource.isBrowserMetricsEnabledDto();
    }

    @POST
    public Response addBrowserMetrics(BrowserMetricsDto browserMetricsDto, @Context HttpServletRequest request) {
        this.originalResource.addBrowserMetricsDto(browserMetricsDto, request.getProtocol());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

