/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.migration.agent.v4.migration.MigrationTracker;
import com.atlassian.migration.agent.v4.pollers.DefaultPollingSettings;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.worker.AttachmentUploadWorker;
import com.atlassian.migration.agent.v4.worker.GlobalEntitiesUploadWorker;
import com.atlassian.migration.agent.v4.worker.SpaceExportWorker;
import com.atlassian.migration.agent.v4.worker.SpaceUploadWorker;
import com.atlassian.migration.agent.v4.worker.UsersGroupsUploadWorker;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSetup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PollingSetup.class);
    private final ClusterManager clusterManager;
    private final AttachmentUploadWorker attachmentOnlyUploadWorker;
    private final UsersGroupsUploadWorker usersGroupsUploadWorker;
    private final SpaceUploadWorker spaceUploadWorker;
    private final SpaceExportWorker spaceExportWorker;
    private final GlobalEntitiesUploadWorker globalEntitiesUploadWorker;
    private final MigrationTracker tracker;

    public PollingSetup(ClusterManager clusterManager, AttachmentUploadWorker attachmentOnlyUploadWorker, UsersGroupsUploadWorker usersGroupsUploadWorker, SpaceUploadWorker spaceUploadWorker, SpaceExportWorker spaceExportWorker, GlobalEntitiesUploadWorker globalEntitiesUploadWorker, MigrationTracker tracker) {
        this.clusterManager = clusterManager;
        this.attachmentOnlyUploadWorker = attachmentOnlyUploadWorker;
        this.usersGroupsUploadWorker = usersGroupsUploadWorker;
        this.spaceUploadWorker = spaceUploadWorker;
        this.spaceExportWorker = spaceExportWorker;
        this.globalEntitiesUploadWorker = globalEntitiesUploadWorker;
        this.tracker = tracker;
    }

    public void init() {
        log.info("Initializing pollers");
        Duration workerPollingDelay = this.clusterManager.isClustered() ? DefaultPollingSettings.DEFAULT_CLUSTERED_POLLING_DELAY : DefaultPollingSettings.DEFAULT_POLLING_DELAY;
        this.tracker.clearInProgressMigrationIds();
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 2), this.attachmentOnlyUploadWorker);
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 1), this.usersGroupsUploadWorker);
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 1), this.globalEntitiesUploadWorker);
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 4), this.spaceUploadWorker);
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 2), this.spaceExportWorker);
        this.tracker.addAndStartStatusPoller(new PollerConfig(DefaultPollingSettings.DEFAULT_STATUS_POLLING_DELAY, 1, 1));
        log.info("Pollers were successfully initialized!");
    }
}

