/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.usage;

import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.logs.TomcatAccessLogParser;
import com.atlassian.migration.agent.service.guardrails.logs.TomcatAccessLogsFinder;
import com.atlassian.migration.agent.service.guardrails.logs.UsageMetricsNodeData;
import com.atlassian.migration.agent.service.guardrails.usage.DailyUsageDetails;
import com.atlassian.migration.agent.service.guardrails.usage.DailyUsageMetricsStore;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AccessLogProcessingJobRunner {
    private static final Logger log = ContextLoggerFactory.getLogger(AccessLogProcessingJobRunner.class);
    protected static final String DEFAULT_NODE = "defaultClusterNode";
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.confluence.migration.guardrails.AccessLogProcessingJobRunner");
    private static final JobId JOB_ID = JobId.of((String)"com.atlassian.confluence.migration.guardrails.AccessLogProcessingJobRunner.JobId");
    private static final JobRunnerKey MERGE_RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.confluence.migration.guardrails.AccessLogProcessingJobRunner-merge");
    private static final JobId MERGE_JOB_ID = JobId.of((String)"com.atlassian.confluence.migration.guardrails.DailyUsageJobRunner.AccessLogProcessingJobRunner-merge");
    private static final Duration SCHEDULER_INTERVAL = Duration.ofHours(1L);
    private static final String CONFIG_JSON = "configJson";
    private final SchedulerService schedulerService;
    private final ClusterInformationService clusterInformationService;
    private final TomcatAccessLogsFinder tomcatAccessLogsFinder;
    private final TomcatAccessLogParser tomcatAccessLogsParser;
    private final DailyUsageMetricsStore dailyUsageMetricsStore;

    public AccessLogProcessingJobRunner(SchedulerService schedulerService, ClusterInformationService clusterInformationService, TomcatAccessLogsFinder tomcatAccessLogsFinder, TomcatAccessLogParser tomcatAccessLogsParser, DailyUsageMetricsStore dailyUsageMetricsStore) {
        this.schedulerService = schedulerService;
        this.clusterInformationService = clusterInformationService;
        this.tomcatAccessLogsFinder = tomcatAccessLogsFinder;
        this.tomcatAccessLogsParser = tomcatAccessLogsParser;
        this.dailyUsageMetricsStore = dailyUsageMetricsStore;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    void postConstruct() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(RUNNER_KEY, this::runParseJob);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)SCHEDULER_INTERVAL.toMillis(), (Date)Date.from(Instant.now().plus(SCHEDULER_INTERVAL)))));
        log.info("Successfully registered access log processing job {}.", (Object)RUNNER_KEY);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    void preDestroy() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(MERGE_RUNNER_KEY);
        log.info("Successfully unregistered access log processing job {}.", (Object)RUNNER_KEY);
    }

    public void startAssessment(InstanceAssessmentConfig config) throws SchedulerServiceException {
        if (config.isCollectUsageMetrics()) {
            String configJson = Jsons.valueAsString(config);
            this.schedulerService.registerJobRunner(MERGE_RUNNER_KEY, this::runMergeJob);
            this.schedulerService.scheduleJob(MERGE_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)MERGE_RUNNER_KEY).withParameters((Map)ImmutableMap.of((Object)CONFIG_JSON, (Object)configJson)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)Date.from(Instant.now().plus(SCHEDULER_INTERVAL.multipliedBy(2L))))));
            log.info("Successfully registered daily usage processing job {}.", (Object)MERGE_RUNNER_KEY);
        }
    }

    public int getProgress() {
        return this.isFinished() ? 100 : this.dailyUsageMetricsStore.getProgress(LocalDate.now());
    }

    public boolean isFinished() {
        return this.schedulerService.getJobsByJobRunnerKey(MERGE_RUNNER_KEY).isEmpty();
    }

    public void cleanup() {
        this.schedulerService.unregisterJobRunner(MERGE_RUNNER_KEY);
        this.schedulerService.unscheduleJob(MERGE_JOB_ID);
    }

    public JobRunnerResponse runParseJob(@NotNull JobRunnerRequest request) {
        try {
            LocalDate today = request.getStartTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate startDate = today.minusDays(14L);
            Map<LocalDate, File> files = this.tomcatAccessLogsFinder.listAccessLogFilesFromDaysAgo(startDate);
            if (files != null) {
                LocalDate max = files.keySet().stream().max(Comparator.naturalOrder()).orElse(today.minusDays(1L));
                LocalDate date = startDate;
                while (!date.isAfter(max)) {
                    this.processFile(date, files.get(date));
                    date = date.plusDays(1L);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to run job - jobId:{} for nodeId:{} ", new Object[]{request.getJobId(), this.getNodeId(), e});
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(LocalDate localDate, File file) throws IOException {
        String nodeId = this.getNodeId();
        if (this.dailyUsageMetricsStore.hasData(nodeId, localDate)) {
            return;
        }
        UsageMetricsNodeData.UsageMetricsNodeDataBuilder nodeBuilder = UsageMetricsNodeData.builder().id(nodeId).nodeStatus(UsageMetricsNodeData.NodeStatus.AVAILABLE);
        DailyUsageDetails.DailyUsageDetailsBuilder builder = DailyUsageDetails.createBuilder(localDate);
        try {
            if (file == null) {
                nodeBuilder.dataCollectionStatus(UsageMetricsNodeData.DataCollectionStatus.MISSING_FILE);
            } else {
                this.tomcatAccessLogsParser.processLines(file, entry -> builder.addLogEntry(entry.getDate(), this.hashUserName(entry.getUser()), entry.getPageType()));
                nodeBuilder.dataCollectionStatus(UsageMetricsNodeData.DataCollectionStatus.COMPLETE);
            }
        }
        catch (Throwable e) {
            log.error("Parsing access logs failed for nodeId: {}", (Object)nodeId);
            nodeBuilder.dataCollectionStatus(UsageMetricsNodeData.DataCollectionStatus.FAILED);
        }
        finally {
            this.dailyUsageMetricsStore.storePartial(builder.nodes((List<UsageMetricsNodeData>)ImmutableList.of((Object)nodeBuilder.build())).build());
        }
    }

    private String hashUserName(String name) {
        return name == null ? null : DigestUtils.sha256Hex((String)name);
    }

    public JobRunnerResponse runMergeJob(@NotNull JobRunnerRequest request) {
        try {
            this.dailyUsageMetricsStore.combine(request.getStartTime().toInstant(), this.getRequiredNodes());
        }
        catch (Exception e) {
            log.error("Failed to run job - jobId:{} for nodeId:{} ", new Object[]{request.getJobId(), this.getNodeId(), e});
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    private List<String> getRequiredNodes() {
        return this.clusterInformationService.isClustered() ? this.clusterInformationService.getAllNodeIds() : ImmutableList.of((Object)this.getNodeId());
    }

    private String getNodeId() {
        return Optional.ofNullable(this.clusterInformationService.getCurrentNodeId()).orElse(DEFAULT_NODE);
    }
}

