/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.agent.service.guardrails.remote.SafeExceptionReport;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class SafeExceptionReporter {
    private static final int MAX_STACK_TRACE_DEPTH = 20;

    public SafeExceptionReport sanitizeException(Throwable exception) {
        List<String> sanitizedStackTrace = this.sanitizeStackTrace(exception);
        Throwable rootCause = this.findRootCause(exception);
        return new SafeExceptionReport(exception.getClass().getName(), Instant.now().toEpochMilli(), sanitizedStackTrace, rootCause != exception ? rootCause.getClass().getName() : null);
    }

    private List<String> sanitizeStackTrace(Throwable exception) {
        ArrayList<String> stackTraceElements = new ArrayList<String>();
        stackTraceElements.add(exception.getClass().getName());
        StackTraceElement[] stackTrace = exception.getStackTrace();
        int maxElements = Math.min(stackTrace.length, 20);
        for (int i = 0; i < maxElements; ++i) {
            stackTraceElements.add("at " + stackTrace[i]);
        }
        for (Throwable cause = exception.getCause(); cause != null && cause != exception; cause = cause.getCause()) {
            stackTraceElements.add("Caused by: " + cause.getClass().getName());
            StackTraceElement[] causeStackTrace = cause.getStackTrace();
            int maxCauseElements = Math.min(causeStackTrace.length, 20);
            for (int i = 0; i < maxCauseElements; ++i) {
                stackTraceElements.add("at " + causeStackTrace[i]);
            }
        }
        return stackTraceElements;
    }

    private Throwable findRootCause(Throwable exception) {
        Throwable cause;
        for (cause = exception; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
        }
        return cause;
    }
}

