/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.guardrails.InfrastructureAssessmentService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfrastructureMetricsJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(InfrastructureMetricsJobRunner.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"infrastructure-metrics-job-runner-key");
    private static final JobId JOB_ID = JobId.of((String)"infrastructure-metrics-job-id");
    protected static final String DEFAULT_NODE = "defaultClusterNode";
    public static final int BYTES_IN_MB = 0x100000;
    private final SchedulerService schedulerService;
    private final ClusterInformationService clusterInformationService;
    private final InfrastructureAssessmentService infrastructureAssessmentService;

    public InfrastructureMetricsJobRunner(SchedulerService schedulerService, ClusterInformationService clusterInformationService, InfrastructureAssessmentService infrastructureAssessmentService) {
        this.schedulerService = schedulerService;
        this.clusterInformationService = clusterInformationService;
        this.infrastructureAssessmentService = infrastructureAssessmentService;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void postConstruct() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)TimeUnit.DAYS.toMillis(1L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(1L))))));
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void preDestroy() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            log.info("Running job {} on node {}", (Object)request.getJobId(), (Object)this.getNodeId());
            this.infrastructureAssessmentService.recordNodeData(this.getNodeId());
            return JobRunnerResponse.success();
        }
        catch (UnsupportedOperationException e) {
            log.error("Data collection not supported on system: ", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error("No permissions to cluster node: ", (Throwable)e);
        }
        return JobRunnerResponse.failed((String)"Error occurred while collecting infrastructure data");
    }

    private String getNodeId() {
        return Optional.ofNullable(this.clusterInformationService.getCurrentNodeId()).orElse(DEFAULT_NODE);
    }
}

