/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.DuplicateEmailsStrategy;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.PreflightLogContext;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.email.DuplicateEmailCheckContext;
import com.atlassian.migration.agent.service.email.FixAllEmailsResult;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.email.UserEmailFixer;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;

public class DuplicateEmailChecker
implements Checker<DuplicateEmailCheckContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(DuplicateEmailChecker.class);
    private final UserEmailFixer userEmailFixer;
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final EmailDuplicateChecker cmptEmailDuplicateChecker;
    private final PreflightLogger preflightLogger;

    public CheckResult check(DuplicateEmailCheckContext ctx) {
        PreflightLogContext logContext = PreflightLogContext.builder().checkType(DuplicateEmailChecker.class.getName()).checkExecutionId(ctx.getCheckExecutionId()).build();
        logContext.addAdditionalProperties("cloudId", ctx.getCloudId());
        this.preflightLogger.logInfo(log, logContext, "Starting duplicate email check");
        List emailData = ctx.getMigrationUsers().stream().map(user -> new EmailData(user.getUsername(), user.getEmail())).collect(Collectors.toList());
        this.preflightLogger.logInfo(log, logContext, String.format("Checking duplicates for %d users", emailData.size()));
        CheckResult checkResult = this.cmptEmailDuplicateChecker.check(new EmailCheckContext(emailData));
        if (!this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            logContext.setIsSuccess(checkResult.success);
            this.preflightLogger.logInfo(log, logContext, "Duplicate email check completed");
            return checkResult;
        }
        DuplicateEmailsConfigDto config = this.globalEmailFixesConfigService.getDuplicateEmailsConfig();
        if (!checkResult.success && config.getActionOnMigration() == DuplicateEmailsStrategy.DO_NOTHING) {
            this.preflightLogger.logInfo(log, logContext, "Duplicate emails found.");
            FixAllEmailsResult fixAllEmailsResult = this.userEmailFixer.fixAllEmailsInMemory(ctx.getMigrationUsers(), ctx.getCloudId());
            boolean success = fixAllEmailsResult.getDuplicateUsers().isEmpty();
            logContext.setIsSuccess(success);
            this.preflightLogger.logInfo(log, logContext, String.format("Email duplicates %s", success ? "resolved successfully" : "could not be resolved"));
            return new CheckResult(success, checkResult.details);
        }
        logContext.setIsSuccess(true);
        this.preflightLogger.logInfo(log, logContext, "Duplicate email check completed successfully");
        return new CheckResult(true, checkResult.details);
    }

    @Generated
    public DuplicateEmailChecker(UserEmailFixer userEmailFixer, GlobalEmailFixesConfigService globalEmailFixesConfigService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, EmailDuplicateChecker cmptEmailDuplicateChecker, PreflightLogger preflightLogger) {
        this.userEmailFixer = userEmailFixer;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.cmptEmailDuplicateChecker = cmptEmailDuplicateChecker;
        this.preflightLogger = preflightLogger;
    }
}

