/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.email;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.ContextProviderUtil;
import com.atlassian.migration.agent.service.check.email.DuplicateEmailCheckContext;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@ParametersAreNonnullByDefault
public class DuplicateEmailCheckContextProvider
implements CheckContextProvider<DuplicateEmailCheckContext> {
    private final UserGroupExtractFacade userGroupExtractFacade;
    private static final String DEFAULT_EXECUTION_ID = "defaultExecutionId";
    private static final String DEFAULT_CHECK_TYPE = "defaultCheckType";

    public DuplicateEmailCheckContextProvider(UserGroupExtractFacade userGroupExtractFacade) {
        this.userGroupExtractFacade = userGroupExtractFacade;
    }

    @Override
    public DuplicateEmailCheckContext apply(Map<String, Object> parameters) {
        String cloudId = ContextProviderUtil.getCloudId(parameters);
        String checkExecutionId = parameters.getOrDefault("checkExecutionId", DEFAULT_EXECUTION_ID).toString();
        String checkType = parameters.getOrDefault("checkType", DEFAULT_CHECK_TYPE).toString();
        if (!parameters.containsKey("spaceKeys")) {
            List<MigrationUser> users = this.userGroupExtractFacade.getAllUsers();
            return new DuplicateEmailCheckContext(users, cloudId, checkExecutionId, checkType);
        }
        String[] spaceKeys = ContextProviderUtil.getSpaceKeys(parameters);
        Optional<GlobalEntityType> globalEntityType = ContextProviderUtil.checkAndGetGlobalEntityType(parameters);
        Set<String> userSet = this.userGroupExtractFacade.getUsersFromSpacesAndGlobalEntities(Arrays.asList(spaceKeys), globalEntityType);
        List<MigrationUser> users = this.userGroupExtractFacade.getAllUsers().stream().filter(u -> userSet.contains(u.getUserKey())).collect(Collectors.toList());
        return new DuplicateEmailCheckContext(users, cloudId, checkExecutionId, checkType);
    }
}

