/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.attachment;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.attachment.AttachmentPathService;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentChecker;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentContext;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentContextProvider;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentMapper;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.SpaceStatisticStore;

@ParametersAreNonnullByDefault
public class MissingAttachmentCheckRegistration
implements CheckRegistration<MissingAttachmentContext> {
    private final MissingAttachmentChecker checker;
    private final MissingAttachmentContextProvider contextProvider;
    private final MissingAttachmentMapper mapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public MissingAttachmentCheckRegistration(PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, AttachmentStore attachmentStore, SpaceStatisticStore spaceStatisticStore, AttachmentPathService attachmentPathService, SystemInformationService systemInformationService, CheckResultFileManager checkResultFileManager, AttachmentManager attachmentManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, AnalyticsEventService analyticsEventService) {
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
        this.checker = new MissingAttachmentChecker(attachmentStore, spaceStatisticStore, attachmentPathService, systemInformationService, checkResultFileManager, attachmentManager, migrationDarkFeaturesManager, preflightChecksAnalyticsEventBuilder, analyticsEventService);
        this.contextProvider = new MissingAttachmentContextProvider();
        this.mapper = new MissingAttachmentMapper();
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.MISSING_ATTACHMENTS;
    }

    @Override
    public Checker<MissingAttachmentContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<MissingAttachmentContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.mapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(AnalyticsEventParams eventParams) {
        CheckResult checkResult = eventParams.getCheckResult();
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightMissingAttachments(eventParams.toPreflightAnalyticsEventParams(), MissingAttachmentChecker.retrieveMissingAttachmentsCount(checkResult.details));
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "missingAttachmentCheck";
    }
}

