/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.InstanceInfoDto;
import com.atlassian.migration.agent.rest.InstanceInfoResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="instance")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
public class InstanceInfoResourceJakarta {
    private final InstanceInfoResource originalResource;

    @Inject
    public InstanceInfoResourceJakarta(InstanceInfoResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/info")
    public Response getServerInstanceInfo() {
        InstanceInfoDto dto = this.originalResource.getServerInstanceInfoDto();
        return Response.ok((Object)dto).build();
    }
}

