/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.SpaceRapidExporter;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import java.nio.file.AccessDeniedException;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Path(value="export")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
public class ExportDebugResource {
    private static final Logger log = ContextLoggerFactory.getLogger(ExportDebugResource.class);
    private static final String VALID_SPACE_PATTERN = "^~?\\w+";
    private final SpaceRapidExporter rapidExporter;
    private final JdbcConfluenceStore confluenceStore;

    @Inject
    public ExportDebugResource(SpaceRapidExporter rapidExporter, JdbcConfluenceStore confluenceStore) {
        this.rapidExporter = rapidExporter;
        this.confluenceStore = confluenceStore;
    }

    @POST
    @Path(value="/new/{spaceKey}")
    public Response newExport(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="excludeContentInTrash") @DefaultValue(value="false") boolean excludeContentInTrash) throws AccessDeniedException {
        Pair<Integer, Object> result = this.newExportDto(spaceKey, excludeContentInTrash);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    private Map<String, String> responsePayloadMap(String message, String file) {
        return ImmutableMap.of((Object)"message", (Object)message, (Object)"file", (Object)file);
    }

    private void validateSpaceKey(String spaceKey) {
        if (StringUtils.isEmpty((CharSequence)spaceKey) || !spaceKey.matches(VALID_SPACE_PATTERN)) {
            throw new IllegalArgumentException("Invalid space key");
        }
    }

    public Pair<Integer, Object> newExportDto(String spaceKey, boolean excludeContentInTrash) throws AccessDeniedException {
        this.validateSpaceKey(spaceKey);
        log.info("Running new export for space {}", (Object)spaceKey);
        SpaceCSVExportTaskContext config = new SpaceCSVExportTaskContext(this.confluenceStore.getSpaceId(spaceKey), spaceKey, "cloudId", "debug-plan", "debug-task", "/tmp", false, excludeContentInTrash);
        String outputFile = this.rapidExporter.export(config);
        return Pair.of((Object)Response.Status.OK.getStatusCode(), this.responsePayloadMap(String.format("New export finished for space: %s", spaceKey), outputFile));
    }
}

