/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.rest.DebugResource;
import com.atlassian.migration.agent.service.check.CheckResultCSVWriter;
import com.atlassian.migration.agent.service.check.attachment.DebugListAttachmentDto;
import com.atlassian.migration.agent.service.check.csv.AbstractCheckResultCSVBean;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.atlassian.migration.agent.service.check.csv.MissingAttachmentCSVContainer;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.net.URI;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@ParametersAreNonnullByDefault
@Path(value="debug")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
public class DebugResourceJakarta {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String USER_DOMAIN_RULE_SELECTION_URI = "/admin/migration.action#choose-domains";
    private final DebugResource originalResource;

    @Inject
    public DebugResourceJakarta(DebugResource originalResource) {
        this.originalResource = originalResource;
    }

    @POST
    @Path(value="/schedule/space-statistic-calculation")
    public Response scheduleSpaceStatisticCalculation() throws Exception {
        return this.originalResource.scheduleSpaceStatisticCalculationDto() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @GET
    @Path(value="/serverId")
    public Response getServerId() {
        return Response.ok((Object)this.originalResource.getServerIdDto()).build();
    }

    @POST
    @Path(value="/mma/emit-space-data")
    public Response emitSpaceData() {
        this.originalResource.emitSpaceDataDto();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/mma/emit-app-data")
    public Response emitAppData() {
        this.originalResource.emitAppDataDto();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/{cloudId}/full-metadata-refresh")
    public Response fullMetadataRefresh(@PathParam(value="cloudId") String cloudId, @QueryParam(value="shouldRetryApps") @DefaultValue(value="false") Boolean shouldRetryApps, @QueryParam(value="shouldRetryDomains") @DefaultValue(value="false") Boolean shouldRetryDomains, @QueryParam(value="shouldRetryServerInstance") @DefaultValue(value="false") Boolean shouldRetryServerInstance, @QueryParam(value="shouldRetrySpaces") @DefaultValue(value="false") Boolean shouldRetrySpaces) {
        this.originalResource.fullMetadataRefreshDto(cloudId, shouldRetryApps, shouldRetryDomains, shouldRetryServerInstance, shouldRetrySpaces);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/view-space-data")
    public Response viewSpaceData() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.originalResource.viewSpaceDataDto()).build();
    }

    @GET
    @Path(value="/assess/l1")
    public Response assessInstance() {
        return Response.ok((Object)this.originalResource.assessInstanceDto()).build();
    }

    @GET
    @Path(value="/assess/{queryId}")
    public Response assessQuery(@PathParam(value="queryId") String queryId) {
        return Response.ok((Object)this.originalResource.assessQueryDto(queryId)).build();
    }

    @GET
    @Path(value="/attachments/{planId}")
    public Response debugAttachments(@PathParam(value="planId") String planId) {
        Pair<Pair<CheckResultCSVWriter, CheckResultCSVContainer<AbstractCheckResultCSVBean>>, String> result = this.originalResource.debugAttachmentsDto(planId);
        Pair writerAndContainer = (Pair)result.getLeft();
        StreamingOutput streamingOutput = output -> ((CheckResultCSVWriter)writerAndContainer.getLeft()).writeResultsInStream(output, (CheckResultCSVContainer)writerAndContainer.getRight());
        return Response.ok((Object)streamingOutput).type(TEXT_CSV).header(CONTENT_DISPOSITION, result.getRight()).build();
    }

    @POST
    @Path(value="/export/space")
    public Response exportSpace(DebugResource.ExportSpacesRequest request) throws Exception {
        Pair<Integer, Object> result = this.originalResource.exportSpaceDto(request);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/extraction/cache/clear/{spaceKey}")
    public Response clearCacheBySpaceKey(@PathParam(value="spaceKey") String spaceKey) {
        this.originalResource.clearCacheBySpaceKeyDto(spaceKey);
        return Response.ok().build();
    }

    @GET
    @Path(value="/status/plan")
    public Response getAllPlans() {
        return Response.ok(this.originalResource.getAllPlansDto()).build();
    }

    @GET
    @Path(value="/status/plan/{planId}")
    public Response getTasksByPlanId(@PathParam(value="planId") String planId) {
        return Response.ok(this.originalResource.getTasksByPlanIdDto(planId)).build();
    }

    @GET
    @Path(value="/status/plan/{planId}/{spaceKey}")
    public Response getDetailsByPlanAndSpaceKey(@PathParam(value="planId") String planId, @PathParam(value="spaceKey") String spaceKey) {
        return Response.ok(this.originalResource.getDetailsByPlanAndSpaceKeyDto(planId, spaceKey)).build();
    }

    @GET
    @Path(value="/status/task/{taskId}")
    public Response getStepsByTaskId(@PathParam(value="taskId") String taskId) {
        return Response.ok(this.originalResource.getStepsByTaskIdDto(taskId)).build();
    }

    @GET
    @Path(value="/mappings/{cloudId}/{migrationScopeId}/{namespace}")
    public Response getMappings(@PathParam(value="cloudId") String cloudId, @PathParam(value="migrationScopeId") String migrationScopeId, @PathParam(value="namespace") String namespace) {
        Pair<Integer, Object> result = this.originalResource.getMappingsDto(cloudId, migrationScopeId, namespace);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/email/trust-all-domains")
    public Response trustAllDomains() throws Exception {
        this.originalResource.trustAllDomainsDto();
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @GET
    @Path(value="/email/remove-all-domain-rules")
    public Response deleteAllUserDomainRules() throws Exception {
        this.originalResource.deleteAllUserDomainRulesDto();
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @POST
    @Path(value="/extract/attachments/{spaceKey}/{pageNumber}")
    public Response getAttachmentsForSpace(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="pageNumber") int pageNumber, @QueryParam(value="excludeContentInTrash") @DefaultValue(value="false") boolean excludeContentInTrash) {
        Triple<Pair<CheckResultCSVWriter, MissingAttachmentCSVContainer>, String, DebugListAttachmentDto> result = this.originalResource.getAttachmentsForSpaceDto(spaceKey, pageNumber, excludeContentInTrash);
        Pair writerAndContainer = (Pair)result.getLeft();
        StreamingOutput streamingOutput = output -> ((CheckResultCSVWriter)writerAndContainer.getLeft()).writeResultsInStream(output, (CheckResultCSVContainer)writerAndContainer.getRight());
        return Response.ok((Object)streamingOutput).type(TEXT_CSV).header(CONTENT_DISPOSITION, result.getMiddle()).header("X-Total-Attachments", (Object)((DebugListAttachmentDto)result.getRight()).getNumberOfAttachments()).header("X-Total-Pages", (Object)((DebugListAttachmentDto)result.getRight()).getTotalNumberOfPages()).header("X-Current-Page", (Object)pageNumber).build();
    }
}

