/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.dto.UserDomainCountDto;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.mma.service.MigrationMetadataAggregatorService;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.SpaceRapidExporter;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.MigrationMappingService;
import com.atlassian.migration.agent.service.check.CheckResultCSVWriter;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.check.attachment.DebugListAttachmentDto;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentChecker;
import com.atlassian.migration.agent.service.check.csv.AbstractCheckResultCSVBean;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.atlassian.migration.agent.service.check.csv.MissingAttachmentCSVBean;
import com.atlassian.migration.agent.service.check.csv.MissingAttachmentCSVContainer;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.guardrails.AssessmentQueries;
import com.atlassian.migration.agent.service.impl.SpaceStatisticCalculationInitialExecutor;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.migration.agent.service.prc.model.RetryCMAState;
import com.atlassian.migration.agent.service.status.MigrationStatusService;
import com.atlassian.migration.agent.service.status.PlanStatusDto;
import com.atlassian.migration.agent.service.status.StepStatusDto;
import com.atlassian.migration.agent.service.status.TaskStatusDto;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.scheduler.SchedulerServiceException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jersey.spi.container.ResourceFilters;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.codehaus.jackson.annotate.JsonCreator;

@ParametersAreNonnullByDefault
@Path(value="debug")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
public class DebugResource {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String USER_DOMAIN_RULE_SELECTION_URI = "/admin/migration.action#choose-domains";
    public static final String PLACEHOLDER = "placeholder";
    private final PreflightService preflightService;
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final MigrationStatusService migrationStatusService;
    private final SpaceRapidExporter spaceRapidExporter;
    private final SpaceManager spaceManager;
    private final BootstrapManager bootstrapManager;
    private final MigrationMappingService migrationMappingService;
    private final UserDomainService userDomainService;
    private final AssessmentQueries assessmentQueries;
    private final SpaceStatisticCalculationInitialExecutor spaceStatisticCalculationInitialExecutor;
    private final MigrationMetadataAggregatorService migrationMetadataAggregatorService;
    private final MissingAttachmentChecker missingAttachmentChecker;
    private final SystemInformationService sysInfoService;

    @Inject
    public DebugResource(PreflightService preflightService, UserGroupExtractFacade userGroupExtractFacade, MigrationStatusService migrationStatusService, SpaceRapidExporter spaceRapidExporter, SpaceManager spaceManager, BootstrapManager bootstrapManager, MigrationMappingService migrationMappingService, UserDomainService userDomainService, AssessmentQueries assessmentQueries, SpaceStatisticCalculationInitialExecutor spaceStatisticCalculationInitialExecutor, MigrationMetadataAggregatorService migrationMetadataAggregatorService, MissingAttachmentChecker missingAttachmentChecker, SystemInformationService sysInfoService) {
        this.preflightService = preflightService;
        this.userGroupExtractFacade = userGroupExtractFacade;
        this.migrationStatusService = migrationStatusService;
        this.spaceRapidExporter = spaceRapidExporter;
        this.spaceManager = spaceManager;
        this.bootstrapManager = bootstrapManager;
        this.migrationMappingService = migrationMappingService;
        this.userDomainService = userDomainService;
        this.assessmentQueries = assessmentQueries;
        this.spaceStatisticCalculationInitialExecutor = spaceStatisticCalculationInitialExecutor;
        this.migrationMetadataAggregatorService = migrationMetadataAggregatorService;
        this.missingAttachmentChecker = missingAttachmentChecker;
        this.sysInfoService = sysInfoService;
    }

    @POST
    @Path(value="/schedule/space-statistic-calculation")
    public Response scheduleSpaceStatisticCalculation() throws SchedulerServiceException {
        return this.scheduleSpaceStatisticCalculationDto() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @GET
    @Path(value="/serverId")
    public Response getServerId() {
        return Response.ok((Object)this.getServerIdDto()).build();
    }

    @POST
    @Path(value="/mma/emit-space-data")
    public Response emitSpaceData() {
        this.emitSpaceDataDto();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/mma/emit-app-data")
    public Response emitAppData() {
        this.emitAppDataDto();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/{cloudId}/full-metadata-refresh")
    public Response fullMetadataRefresh(@PathParam(value="cloudId") String cloudId, @QueryParam(value="shouldRetryApps") @DefaultValue(value="false") Boolean shouldRetryApps, @QueryParam(value="shouldRetryDomains") @DefaultValue(value="false") Boolean shouldRetryDomains, @QueryParam(value="shouldRetryServerInstance") @DefaultValue(value="false") Boolean shouldRetryServerInstance, @QueryParam(value="shouldRetrySpaces") @DefaultValue(value="false") Boolean shouldRetrySpaces) {
        this.fullMetadataRefreshDto(cloudId, shouldRetryApps, shouldRetryDomains, shouldRetryServerInstance, shouldRetrySpaces);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/view-space-data")
    public Response viewSpaceData() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.viewSpaceDataDto()).build();
    }

    @GET
    @Path(value="/assess/l1")
    public Response assessInstance() {
        return Response.ok((Object)this.assessInstanceDto()).build();
    }

    @GET
    @Path(value="/assess/{queryId}")
    public Response assessQuery(@PathParam(value="queryId") String queryId) {
        return Response.ok((Object)this.assessQueryDto(queryId)).build();
    }

    @GET
    @Path(value="/attachments/{planId}")
    public Response debugAttachments(@PathParam(value="planId") String planId) {
        Pair<Pair<CheckResultCSVWriter, CheckResultCSVContainer<AbstractCheckResultCSVBean>>, String> result = this.debugAttachmentsDto(planId);
        Pair writerAndContainer = (Pair)result.getLeft();
        StreamingOutput streamingOutput = output -> ((CheckResultCSVWriter)writerAndContainer.getLeft()).writeResultsInStream(output, (CheckResultCSVContainer)writerAndContainer.getRight());
        return Response.ok((Object)streamingOutput).type(TEXT_CSV).header(CONTENT_DISPOSITION, result.getRight()).build();
    }

    @POST
    @Path(value="/export/space")
    public Response exportSpace(ExportSpacesRequest request) throws Exception {
        Pair<Integer, Object> result = this.exportSpaceDto(request);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/extraction/cache/clear/{spaceKey}")
    public Response clearCacheBySpaceKey(@PathParam(value="spaceKey") String spaceKey) {
        this.clearCacheBySpaceKeyDto(spaceKey);
        return Response.ok().build();
    }

    @GET
    @Path(value="/status/plan")
    public Response getAllPlans() {
        return Response.ok(this.getAllPlansDto()).build();
    }

    @GET
    @Path(value="/status/plan/{planId}")
    public Response getTasksByPlanId(@PathParam(value="planId") String planId) {
        return Response.ok(this.getTasksByPlanIdDto(planId)).build();
    }

    @GET
    @Path(value="/status/plan/{planId}/{spaceKey}")
    public Response getDetailsByPlanAndSpaceKey(@PathParam(value="planId") String planId, @PathParam(value="spaceKey") String spaceKey) {
        return Response.ok(this.getDetailsByPlanAndSpaceKeyDto(planId, spaceKey)).build();
    }

    @GET
    @Path(value="/status/task/{taskId}")
    public Response getStepsByTaskId(@PathParam(value="taskId") String taskId) {
        return Response.ok(this.getStepsByTaskIdDto(taskId)).build();
    }

    @GET
    @Path(value="/mappings/{cloudId}/{migrationScopeId}/{namespace}")
    public Response getMappings(@PathParam(value="cloudId") String cloudId, @PathParam(value="migrationScopeId") String migrationScopeId, @PathParam(value="namespace") String namespace) {
        Pair<Integer, Object> result = this.getMappingsDto(cloudId, migrationScopeId, namespace);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/email/trust-all-domains")
    public Response trustAllDomains() throws URISyntaxException {
        this.trustAllDomainsDto();
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @GET
    @Path(value="/email/remove-all-domain-rules")
    public Response deleteAllUserDomainRules() throws URISyntaxException {
        this.deleteAllUserDomainRulesDto();
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @POST
    @Path(value="/extract/attachments/{spaceKey}/{pageNumber}")
    public Response getAttachmentsForSpace(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="pageNumber") int pageNumber, @QueryParam(value="excludeContentInTrash") @DefaultValue(value="false") boolean excludeContentInTrash) {
        Triple<Pair<CheckResultCSVWriter, MissingAttachmentCSVContainer>, String, DebugListAttachmentDto> result = this.getAttachmentsForSpaceDto(spaceKey, pageNumber, excludeContentInTrash);
        Pair writerAndContainer = (Pair)result.getLeft();
        StreamingOutput streamingOutput = output -> ((CheckResultCSVWriter)writerAndContainer.getLeft()).writeResultsInStream(output, (CheckResultCSVContainer)writerAndContainer.getRight());
        return Response.ok((Object)streamingOutput).type(TEXT_CSV).header(CONTENT_DISPOSITION, result.getMiddle()).header("X-Total-Attachments", (Object)((DebugListAttachmentDto)result.getRight()).getNumberOfAttachments()).header("X-Total-Pages", (Object)((DebugListAttachmentDto)result.getRight()).getTotalNumberOfPages()).header("X-Current-Page", (Object)pageNumber).build();
    }

    public boolean scheduleSpaceStatisticCalculationDto() throws SchedulerServiceException {
        return this.spaceStatisticCalculationInitialExecutor.scheduleWithForceUpdate();
    }

    public String getServerIdDto() {
        return this.sysInfoService.getConfluenceInfo().getServerId();
    }

    public void emitSpaceDataDto() {
        this.migrationMetadataAggregatorService.sendSpaceMetadataToMMAForAllCloudSites();
    }

    public void emitAppDataDto() {
        this.migrationMetadataAggregatorService.sendAppMetadataToMMAForAllCloudSites();
    }

    public void fullMetadataRefreshDto(String cloudId, Boolean shouldRetryApps, Boolean shouldRetryDomains, Boolean shouldRetryServerInstance, Boolean shouldRetrySpaces) {
        RetryCMAState cmaState = RetryCMAState.builder().shouldRetryApps(shouldRetryApps).shouldRetryDomains(shouldRetryDomains).shouldRetryServerInstance(shouldRetryServerInstance).shouldRetrySpaces(shouldRetrySpaces).build();
        this.migrationMetadataAggregatorService.replaceAllMetadata(cloudId, cmaState);
    }

    public Object viewSpaceDataDto() {
        return this.migrationMetadataAggregatorService.buildSpaceMetadata(PLACEHOLDER, PLACEHOLDER);
    }

    public Object assessInstanceDto() {
        return this.assessmentQueries.executeAllQueries();
    }

    public Object assessQueryDto(String queryId) {
        return this.assessmentQueries.executeQuery(QueryIds.valueOf(queryId));
    }

    public Pair<Pair<CheckResultCSVWriter, CheckResultCSVContainer<AbstractCheckResultCSVBean>>, String> debugAttachmentsDto(String planId) {
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        CheckResultCSVContainer checkResultCSVContainer = this.preflightService.createCheckResultCSVContainer(planId, CheckType.MISSING_ATTACHMENTS);
        String contentDisposition = String.format("attachment; filename=\"%s-%s.csv\"; creation-date=\"%s\"", planId, CheckType.MISSING_ATTACHMENTS.value(), DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
        return Pair.of((Object)Pair.of((Object)writer, (Object)checkResultCSVContainer), (Object)contentDisposition);
    }

    public Pair<Integer, Object> exportSpaceDto(ExportSpacesRequest request) throws Exception {
        String cloudId = String.format("Debug space export dummy PlanId %s", UUID.randomUUID());
        String planId = String.format("Debug space export dummy PlanId %s", UUID.randomUUID());
        String taskId = String.format("Debug space export dummy TaskId %s", UUID.randomUUID());
        String spaceKey = request.getSpaceKey();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)"The specified space does not exist.");
        }
        SpaceCSVExportTaskContext config = new SpaceCSVExportTaskContext(space.getId(), space.getKey(), cloudId, planId, taskId, SpaceExportExecutor.getFilePathProperty(this.bootstrapManager), false, request.isExcludeContentInTrash());
        String exportPath = this.spaceRapidExporter.export(config);
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new ExportSpacesResponse(exportPath, spaceKey));
    }

    public void clearCacheBySpaceKeyDto(String spaceKey) {
        this.userGroupExtractFacade.clearCache(spaceKey);
    }

    public List<PlanStatusDto> getAllPlansDto() {
        return this.migrationStatusService.getAllPlans();
    }

    public List<TaskStatusDto> getTasksByPlanIdDto(String planId) {
        return this.migrationStatusService.getTasksByPlan(planId);
    }

    public Map<String, Object> getDetailsByPlanAndSpaceKeyDto(String planId, String spaceKey) {
        return this.migrationStatusService.getDetailsByPlanAndSpaceKey(planId, spaceKey);
    }

    public List<StepStatusDto> getStepsByTaskIdDto(String taskId) {
        return this.migrationStatusService.getStepsByTask(taskId);
    }

    public Pair<Integer, Object> getMappingsDto(String cloudId, String migrationScopeId, String namespace) {
        if (!MigrationMappingService.CONFLUENCE_MAPPINGS.contains((Object)namespace)) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto(namespace + " is not a valid confluence namespace"));
        }
        return Pair.of((Object)Response.Status.OK.getStatusCode(), this.migrationMappingService.getMappings(cloudId, migrationScopeId, namespace));
    }

    public void trustAllDomainsDto() {
        List<UserDomainCountDto> domains = this.userDomainService.getUserDomainCounts();
        domains.forEach(domain -> this.userDomainService.upsertDomainRule(new UserDomainRuleDto(domain.getDomainName(), DomainRuleBehaviour.TRUSTED)));
    }

    public void deleteAllUserDomainRulesDto() {
        this.userDomainService.deleteAllDomainRules();
    }

    public Triple<Pair<CheckResultCSVWriter, MissingAttachmentCSVContainer>, String, DebugListAttachmentDto> getAttachmentsForSpaceDto(String spaceKey, int pageNumber, boolean excludeContentInTrash) {
        DebugListAttachmentDto debugListAttachmentDto = this.missingAttachmentChecker.getAttachmentsForSpace(spaceKey, pageNumber, excludeContentInTrash);
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        List<MissingAttachmentCSVBean> beans = debugListAttachmentDto.getMissingAttachmentDto().stream().map(MissingAttachmentCSVBean::new).collect(Collectors.toList());
        MissingAttachmentCSVContainer checkResultCSVContainer = new MissingAttachmentCSVContainer(beans);
        String contentDisposition = String.format("attachment; filename=\"%s.csv\"; creation-date=\"%s\"", "Attachments to migrate", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
        return Triple.of((Object)Pair.of((Object)writer, (Object)checkResultCSVContainer), (Object)contentDisposition, (Object)debugListAttachmentDto);
    }

    public static final class ExportSpacesRequest {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String spaceKey;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final boolean excludeContentInTrash;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public ExportSpacesRequest(@org.codehaus.jackson.annotate.JsonProperty(value="spaceKey") @JsonProperty(value="spaceKey") String spaceKey, @org.codehaus.jackson.annotate.JsonProperty(value="excludeContentInTrash") @JsonProperty(value="excludeContentInTrash") boolean excludeContentInTrash) {
            this.spaceKey = spaceKey;
            this.excludeContentInTrash = excludeContentInTrash;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }

        @Generated
        public boolean isExcludeContentInTrash() {
            return this.excludeContentInTrash;
        }
    }

    public static final class ExportSpacesResponse {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String location;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String spaceKey;

        public ExportSpacesResponse(String location, String spaceKey) {
            this.location = location;
            this.spaceKey = spaceKey;
        }

        @Generated
        public String getLocation() {
            return this.location;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }
    }
}

