/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.compatibility;

import com.atlassian.migration.agent.service.ServiceInitializeException;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class WebApplicationExceptionFactory {
    private static final String JAKARTA_CLASS = "jakarta.ws.rs.WebApplicationException";
    private static final String JAVAX_CLASS = "javax.ws.rs.WebApplicationException";
    private static final Class<?> EXCEPTION_CLASS;
    private static final Constructor<?> CTOR_INT;
    private static final Constructor<?> CTOR_STRING;
    private static final Constructor<?> CTOR_THROWABLE;
    private static final Constructor<?> CTOR_THROWABLE_INT;
    private static final Constructor<?> CTOR_STRING_INT;

    @NotNull
    private static Class<?> getClazz() throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(JAKARTA_CLASS);
        }
        catch (ClassNotFoundException e) {
            clazz = Class.forName(JAVAX_CLASS);
        }
        return clazz;
    }

    private WebApplicationExceptionFactory() {
        throw new AssertionError((Object)"No instances");
    }

    public static RuntimeException create(int status) {
        try {
            return (RuntimeException)CTOR_INT.newInstance(status);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to create WebApplicationException with status: " + status, e);
        }
    }

    public static RuntimeException create(String message) {
        try {
            return (RuntimeException)CTOR_STRING.newInstance(message);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to create WebApplicationException with message: " + message, e);
        }
    }

    public static RuntimeException create(Throwable cause) {
        try {
            return (RuntimeException)CTOR_THROWABLE.newInstance(cause);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to create WebApplicationException with cause", e);
        }
    }

    public static RuntimeException create(Throwable cause, int status) {
        try {
            return (RuntimeException)CTOR_THROWABLE_INT.newInstance(cause, status);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to create WebApplicationException with message and status", e);
        }
    }

    public static RuntimeException create(String message, int status) {
        try {
            return (RuntimeException)CTOR_STRING_INT.newInstance(message, status);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to create WebApplicationException with message and status", e);
        }
    }

    public static Class<?> getExceptionClass() {
        return EXCEPTION_CLASS;
    }

    public static boolean isUsingJakarta() {
        return JAKARTA_CLASS.equals(EXCEPTION_CLASS.getName());
    }

    public static boolean isUsingJavax() {
        return JAVAX_CLASS.equals(EXCEPTION_CLASS.getName());
    }

    static {
        try {
            Class<?> clazz = WebApplicationExceptionFactory.getClazz();
            EXCEPTION_CLASS = clazz;
            CTOR_INT = EXCEPTION_CLASS.getConstructor(Integer.TYPE);
            CTOR_STRING = EXCEPTION_CLASS.getConstructor(String.class);
            CTOR_THROWABLE = EXCEPTION_CLASS.getConstructor(Throwable.class);
            CTOR_THROWABLE_INT = EXCEPTION_CLASS.getConstructor(Throwable.class, Integer.TYPE);
            CTOR_STRING_INT = EXCEPTION_CLASS.getConstructor(String.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceInitializeException("Neither Jakarta nor Javax WebApplicationException found on classpath. This indicates a missing JAX-RS dependency.", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceInitializeException("WebApplicationException class found but expected constructors are missing", e);
        }
    }
}

