/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.analytics;

import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.app.analytics.prometheus.PrometheusMetricPollerJobContext;
import com.atlassian.migration.app.analytics.prometheus.PrometheusMetricSinkInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;

public class McsRemotePrometheusSnapshotSink
implements PrometheusMetricSinkInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McsRemotePrometheusSnapshotSink.class);
    private static final String PREFIX = "prometheus";
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final String migrationId;
    private final String cloudId;
    private final File tempDir;
    private final AtomicInteger index = new AtomicInteger(0);

    public McsRemotePrometheusSnapshotSink(MigrationCatalogueStorageService migrationCatalogueStorageService, String migrationId, String cloudId) {
        this(migrationCatalogueStorageService, migrationId, cloudId, () -> {
            try {
                return Files.createTempDirectory("prometheus-zips-" + cloudId, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    McsRemotePrometheusSnapshotSink(MigrationCatalogueStorageService migrationCatalogueStorageService, String migrationId, String cloudId, Supplier<File> tempDirProvider) {
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.migrationId = migrationId;
        this.cloudId = cloudId;
        this.tempDir = tempDirProvider.get();
    }

    public void close(@NotNull PrometheusMetricPollerJobContext ctx) {
        FileSystemUtils.deleteRecursively((File)this.tempDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull byte[] bytes, @NotNull PrometheusMetricPollerJobContext ctx) {
        String fileName = String.format("Migration_Metrics_%s_%s", ctx.getPollerInstanceId(), this.index.getAndIncrement());
        try {
            File tempFile = new File(this.tempDir, fileName);
            try {
                tempFile.createNewFile();
                try (FileOutputStream tempFileStream = new FileOutputStream(tempFile);){
                    tempFileStream.write(bytes);
                }
                this.migrationCatalogueStorageService.uploadMultipartFileToMCSWithPrefix(this.cloudId, this.migrationId, tempFile.toPath(), PREFIX);
            }
            finally {
                Files.delete(tempFile.toPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed uploading prometheus metrics to MCS", e);
        }
    }
}

