/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.TemplatedQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;

public class GuardrailsQueries {
    private static final int DEFAULT_LIMIT = 100;
    private static final int BODY_CONTENT_FILTER_LENGTH = 40000;
    public static final String SIZE_OF_DB_DEFAULT_QUERY = "SELECT pg_database.datname as database, cast(pg_database_size(pg_database.datname) as numeric)/1024/1024/1024 AS size FROM pg_database\n ORDER by size DESC";
    public static final String SIZE_OF_DB_ORACLE_QUERY = "SELECT TABLESPACE_NAME as \"database_name\", SUM(BYTES)/1024/1024/1024 AS \"size_in_gb\" FROM USER_TABLESPACES JOIN USER_SEGMENTS USING (TABLESPACE_NAME) GROUP BY TABLESPACE_NAME ORDER BY \"size_in_gb\" DESC";
    public static final String SIZE_OF_DB_MSSQL_QUERY = "SELECT\n    DB_NAME(db.database_id) DatabaseName,\n    (CAST(mfrows.RowSize AS FLOAT)*8)/1024 RowSizeMB,\n    (CAST(mflog.LogSize AS FLOAT)*8)/1024 LogSizeMB,\n    (CAST(mfstream.StreamSize AS FLOAT)*8)/1024 StreamSizeMB,\n    (CAST(mftext.TextIndexSize AS FLOAT)*8)/1024 TextIndexSizeMB\nFROM sys.databases db\n    LEFT JOIN (SELECT database_id, SUM(size) RowSize FROM sys.master_files WHERE type = 0 GROUP BY database_id, type) mfrows ON mfrows.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) LogSize FROM sys.master_files WHERE type = 1 GROUP BY database_id, type) mflog ON mflog.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) StreamSize FROM sys.master_files WHERE type = 2 GROUP BY database_id, type) mfstream ON mfstream.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) TextIndexSize FROM sys.master_files WHERE type = 4 GROUP BY database_id, type) mftext ON mftext.database_id = db.database_id";
    public static final String SIZE_OF_DB_MYSQL_QUERY = "SELECT table_schema AS \"database\", round(SUM(data_length + index_length)/1024/1024/1024, 2) AS \"size\" \n FROM information_schema.TABLES\n GROUP BY \"database\" \n ORDER BY \"size\"";
    public static final String SIZE_OF_DB_H2_QUERY = "SELECT table_schema as database, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY size DESC \n LIMIT 100";
    static final TemplatedQuery SIZE_OF_DB_QUERY = new TemplatedQuery("SELECT pg_database.datname as database, cast(pg_database_size(pg_database.datname) as numeric)/1024/1024/1024 AS size FROM pg_database\n ORDER by size DESC", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"SELECT TABLESPACE_NAME as \"database_name\", SUM(BYTES)/1024/1024/1024 AS \"size_in_gb\" FROM USER_TABLESPACES JOIN USER_SEGMENTS USING (TABLESPACE_NAME) GROUP BY TABLESPACE_NAME ORDER BY \"size_in_gb\" DESC", (Object)((Object)DbType.MSSQL), (Object)"SELECT\n    DB_NAME(db.database_id) DatabaseName,\n    (CAST(mfrows.RowSize AS FLOAT)*8)/1024 RowSizeMB,\n    (CAST(mflog.LogSize AS FLOAT)*8)/1024 LogSizeMB,\n    (CAST(mfstream.StreamSize AS FLOAT)*8)/1024 StreamSizeMB,\n    (CAST(mftext.TextIndexSize AS FLOAT)*8)/1024 TextIndexSizeMB\nFROM sys.databases db\n    LEFT JOIN (SELECT database_id, SUM(size) RowSize FROM sys.master_files WHERE type = 0 GROUP BY database_id, type) mfrows ON mfrows.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) LogSize FROM sys.master_files WHERE type = 1 GROUP BY database_id, type) mflog ON mflog.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) StreamSize FROM sys.master_files WHERE type = 2 GROUP BY database_id, type) mfstream ON mfstream.database_id = db.database_id\n    LEFT JOIN (SELECT database_id, SUM(size) TextIndexSize FROM sys.master_files WHERE type = 4 GROUP BY database_id, type) mftext ON mftext.database_id = db.database_id", (Object)((Object)DbType.MYSQL), (Object)"SELECT table_schema AS \"database\", round(SUM(data_length + index_length)/1024/1024/1024, 2) AS \"size\" \n FROM information_schema.TABLES\n GROUP BY \"database\" \n ORDER BY \"size\"", (Object)((Object)DbType.H2), (Object)"SELECT table_schema as database, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY size DESC \n LIMIT 100"));
    public static final String SIZE_OF_TABLES_DEFAULT_QUERY = String.format("SELECT cast(C.oid as varchar) as database, nspname || '.' || relname AS table, cast(pg_relation_size(C.oid) AS numeric)/1024/1024/1024 AS size \n FROM pg_class C\n LEFT JOIN pg_namespace N O  N (N.oid = C.relnamespace) WHERE nspname NOT IN ('pg_catalog', 'information_schema')  ORDER BY pg_relation_size(C.oid) DESC LIMIT %d", 100);
    public static final String SIZE_OF_TABLES_ORACLE_QUERY = String.format("SELECT TABLESPACE_NAME AS \"database_name\", SEGMENT_NAME AS \"table_name\", SUM(BYTES)/1024/1024/1024 AS \"table_size\" FROM USER_SEGMENTS WHERE SEGMENT_TYPE = 'TABLE' GROUP BY TABLESPACE_NAME, SEGMENT_NAME ORDER BY \"table_size\" DESC FETCH FIRST %d ROWS ONLY", 100);
    public static final String SIZE_OF_TABLES_MSSQL_QUERY = String.format("SELECT TOP %d s.name as \"database\", t.NAME AS \"table\", CAST(SUM(a.total_pages) * 8 / 1024.0 / 1024.0 AS DECIMAL(10,2)) AS size \n  FROM sys.tables t \n  INNER JOIN sys.indexes i ON t.OBJECT_ID = i.object_id \n  INNER JOIN sys.partitions p ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id \n  INNER JOIN sys.allocation_units a ON p.partition_id = a.container_id \n  LEFT OUTER JOIN sys.schemas s ON t.schema_id = s.schema_id \n  WHERE t.NAME NOT LIKE 'dt%%' \n  AND t.is_ms_shipped = 0 \n  AND i.OBJECT_ID > 255 \n  GROUP BY t.Name, s.Name \n  ORDER BY size DESC", 100);
    public static final String SIZE_OF_TABLES_MYSQL_QUERY = String.format("SELECT \n  table_schema as \"database\", \n  table_name AS \"table\", \n  round(((data_length + index_length))/1024/1024/1024, 2) \"size\" \n FROM information_schema.TABLES \n ORDER BY (data_length + index_length) DESC LIMIT %d", 100);
    public static final String SIZE_OF_TABLES_H2_QUERY = String.format("SELECT table_schema as database, table_name as table, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY ROW_COUNT_ESTIMATE DESC LIMIT %d", 100);
    static final TemplatedQuery SIZE_OF_TABLES_QUERY = new TemplatedQuery(SIZE_OF_TABLES_DEFAULT_QUERY, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)SIZE_OF_TABLES_ORACLE_QUERY, (Object)((Object)DbType.MSSQL), (Object)SIZE_OF_TABLES_MSSQL_QUERY, (Object)((Object)DbType.MYSQL), (Object)SIZE_OF_TABLES_MYSQL_QUERY, (Object)((Object)DbType.H2), (Object)SIZE_OF_TABLES_H2_QUERY));
    public static final String SIZE_OF_TABLES_PER_PAGE_DEFAULT_QUERY = String.format("select content.id as page_id, (length(bc.body) - length(replace(bc.body, '<td>', ''))) / length('<td>') as table_size, content.version as page_edit_frequency from Content content inner join BodyContent bc on content.id = bc.contentId where bc.body <> '' and length(bc.body) > %d and content.type in ('PAGE', 'BLOGPOST') and content.status in ('current', 'draft') and content.previousVersion is null", 40000);
    public static final String SIZE_OF_TABLES_PER_PAGE_ORACLE_QUERY = String.format("select content.contentid, (length(bodycontent.body) - length(replace(bodycontent.body, '<td>', ''))) / length('<td>') as table_size, content.version as page_edit_frequency from Content content inner join bodycontent on content.contentid = bodycontent.contentid where bodycontent.body is not null and length(bodycontent.body) > %d and content.contenttype in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.prevver is null", 40000);
    public static final String SIZE_OF_TABLES_PER_PAGE_MSSQL_QUERY = String.format("select content.CONTENTID, (len(CONVERT(VARCHAR(MAX), BODY)) - LEN(replace(CONVERT(VARCHAR(MAX), BODY), '<td>', ''))) / LEN(CONVERT(VARCHAR(MAX), '<td>')) as table_size, content.VERSION as page_edit_frequency from CONTENT content inner join BODYCONTENT bodycontent on content.CONTENTID = bodycontent.CONTENTID where content.CONTENTTYPE in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.PREVVER is null", new Object[0]);
    static final TemplatedQuery SIZE_OF_TABLES_PER_PAGE_QUERY = new TemplatedQuery(SIZE_OF_TABLES_PER_PAGE_DEFAULT_QUERY, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MSSQL), (Object)SIZE_OF_TABLES_PER_PAGE_MSSQL_QUERY, (Object)((Object)DbType.ORACLE), (Object)SIZE_OF_TABLES_PER_PAGE_ORACLE_QUERY));
    public static final String PAGE_DEPTH_DEFAULT_QUERY = "with recursive query as  (select 0 as depth, contentid, spaceid  from CONTENT  where parentid is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union select depth + 1, child.contentid, child.spaceid  from CONTENT child  inner join query on child.parentid = query.contentid where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select query.spaceid as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.spaceid = spaces.spaceid group by query.spaceid order by max_depth desc";
    public static final String PAGE_DEPTH_ORACLE_QUERY = "with query (depth,CONTENTID,SPACEID) as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select query.SPACEID as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID group by query.SPACEID order by max_depth desc";
    public static final String PAGE_DEPTH_MSSQL_QUERY = "with query as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select CAST(query.SPACEID AS BIGINT) AS \"space_id\", max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID  group by query.SPACEID order by max_depth desc";
    public static final String PAGE_DEPTH_ROOT_PAGE_QUERY = "select CONTENTID FROM CONTENT WHERE PARENTID is NULL and CONTENT_STATUS = 'current' and PREVVER is NULL and CONTENTTYPE = 'PAGE';";
    static final TemplatedQuery PAGE_DEPTH_QUERY = new TemplatedQuery("with recursive query as  (select 0 as depth, contentid, spaceid  from CONTENT  where parentid is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union select depth + 1, child.contentid, child.spaceid  from CONTENT child  inner join query on child.parentid = query.contentid where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select query.spaceid as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.spaceid = spaces.spaceid group by query.spaceid order by max_depth desc", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"with query (depth,CONTENTID,SPACEID) as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select query.SPACEID as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID group by query.SPACEID order by max_depth desc", (Object)((Object)DbType.MSSQL), (Object)"with query as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  and PREVVER is NULL  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID where child.CONTENT_STATUS = 'current' and child.CONTENTTYPE in ('PAGE') and child.PREVVER is NULL)  select CAST(query.SPACEID AS BIGINT) AS \"space_id\", max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID  group by query.SPACEID order by max_depth desc", (Object)((Object)DbType.H2), (Object)""));
    public static final String NUMBER_OF_TABLES_PER_PAGE_DEFAULT_QUERY = String.format("select content.id as page_id, (length(bc.body) - length(replace(bc.body, '</table>', ''))) / length('</table>') as table_count, content.version as page_edit_frequency from Content content inner join BodyContent bc on content.id = bc.contentId where bc.body <> '' and length(bc.body) > %d and content.type in ('PAGE', 'BLOGPOST') and content.status in ('current', 'draft') and content.previousVersion is null", 40000);
    public static final String NUMBER_OF_TABLES_PER_PAGE_ORACLE_QUERY = String.format("select content.contentid, (length(bodycontent.body) - length(replace(bodycontent.body, '</table>', ''))) / length('</table>') as table_size, content.version as page_edit_frequency from Content content inner join bodycontent on content.contentid = bodycontent.contentid where bodycontent.body is not null and length(bodycontent.body) > %d and content.contenttype in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.prevver is null", 40000);
    public static final String NUMBER_OF_TABLES_PER_PAGE_MSSQL_QUERY = "select content.CONTENTID, (len(CONVERT(VARCHAR(MAX), BODY)) - len(replace(CONVERT(VARCHAR(MAX), BODY), '</table>', ''))) / len(CONVERT(VARCHAR(MAX), '</table>')) as cnt, content.VERSION as page_edit_frequency from CONTENT content inner join BODYCONTENT bodycontent on content.CONTENTID = bodycontent.CONTENTID where content.CONTENTTYPE in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.PREVVER is null";
    static final TemplatedQuery NUMBER_OF_TABLES_PER_PAGE = new TemplatedQuery(NUMBER_OF_TABLES_PER_PAGE_DEFAULT_QUERY, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MSSQL), (Object)"select content.CONTENTID, (len(CONVERT(VARCHAR(MAX), BODY)) - len(replace(CONVERT(VARCHAR(MAX), BODY), '</table>', ''))) / len(CONVERT(VARCHAR(MAX), '</table>')) as cnt, content.VERSION as page_edit_frequency from CONTENT content inner join BODYCONTENT bodycontent on content.CONTENTID = bodycontent.CONTENTID where content.CONTENTTYPE in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.PREVVER is null", (Object)((Object)DbType.ORACLE), (Object)NUMBER_OF_TABLES_PER_PAGE_ORACLE_QUERY));
    public static final String EMBEDDED_ATT_PER_PAGE_DEFAULT_QUERY = String.format("select content.id as page_id, (length(bc.body) - length(replace(bc.body, '<ri:attachment', ''))) / length('<ri:attachment') as attachment_count  from Content content inner join BodyContent bc on content.id = bc.contentId  where bc.body <> '' and length(bc.body) > %d  and content.type in ('PAGE', 'BLOGPOST') and content.previousVersion is null and content.status in ('current', 'draft')  order by attachment_count desc", 40000);
    public static final String EMBEDDED_ATT_PER_PAGE_MSSQL_QUERY = String.format("select content.CONTENTID as page_id, (len(CONVERT(VARCHAR(MAX), BODY)) - len(replace(CONVERT(VARCHAR(MAX), BODY), '<ri:attachment', ''))) / len(CONVERT(VARCHAR(MAX), '<ri:attachment')) as attachment_count from CONTENT content inner join BODYCONTENT bc on content.CONTENTID = bc.CONTENTID where len(CONVERT(VARCHAR(MAX), BODY)) > %d and content.CONTENTTYPE in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.PREVVER is null ORDER BY attachment_count DESC", 40000);
    public static final String EMBEDDED_ATT_PER_PAGE_ORACLE_QUERY = String.format("select content.contentid as page_id, (length(bodycontent.body) - length(replace(bodycontent.body, '<ri:attachment', ''))) / length('<ri:attachment') as attachment_count from Content content inner join bodycontent on content.contentid = bodycontent.contentid where bodycontent.body is not null and length(bodycontent.body) > %d and content.contenttype in ('PAGE', 'BLOGPOST') and content.CONTENT_STATUS in ('current', 'draft') and content.prevver is null order by attachment_count desc", 40000);
    static final TemplatedQuery EMBEDDED_ATT_PER_PAGE = new TemplatedQuery(EMBEDDED_ATT_PER_PAGE_DEFAULT_QUERY, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MSSQL), (Object)EMBEDDED_ATT_PER_PAGE_MSSQL_QUERY, (Object)((Object)DbType.ORACLE), (Object)EMBEDDED_ATT_PER_PAGE_ORACLE_QUERY));
    static final String TOTAL_TEAM_CALENDARS_DEFAULT_QUERY = "SELECT COUNT(*) AS teamCalendarCount FROM \"AO_950DC3_TC_SUBCALS_IN_SPACE\"";
    static final String TOTAL_TEAM_CALENDARS_MYSQL_QUERY = "SELECT COUNT(*) AS teamCalendarCount FROM AO_950DC3_TC_SUBCALS_IN_SPACE";
    static final TemplatedQuery TOTAL_TEAM_CALENDARS = new TemplatedQuery("SELECT COUNT(*) AS teamCalendarCount FROM \"AO_950DC3_TC_SUBCALS_IN_SPACE\"", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.MYSQL), (Object)"SELECT COUNT(*) AS teamCalendarCount FROM AO_950DC3_TC_SUBCALS_IN_SPACE"));
    public static final String CONFLUENCE_LICENSED_ACTIVE_USERS_POSTGRES_QUERY = "SELECT COUNT(distinct cwd_user.user_name) as user_count\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id= cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'";
    public static final String CONFLUENCE_LICENSED_ACTIVE_USERS_MYSQL_QUERY = "SELECT COUNT(DISTINCT cwd_user.user_name) as user_count\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id = cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'";
    public static final String CONFLUENCE_LICENSED_ACTIVE_USERS_MSSQL_QUERY = "SELECT COUNT(DISTINCT dbo.cwd_user.user_name) AS user_count\nFROM dbo.cwd_group\nINNER JOIN dbo.cwd_membership ON dbo.cwd_membership.parent_id = cwd_group.id\nINNER JOIN dbo.cwd_user ON dbo.cwd_user.id = dbo.cwd_membership.child_user_id\nWHERE dbo.cwd_user.active = 'T'";
    public static final String CONFLUENCE_LICENSED_ACTIVE_USERS_ORACLE_QUERY = "SELECT COUNT(distinct cwd_user.user_name)\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id= cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'";
    static final TemplatedQuery CONFLUENCE_LICENSED_ACTIVE_USERS = new TemplatedQuery("SELECT COUNT(distinct cwd_user.user_name) as user_count\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id= cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.POSTGRES), (Object)"SELECT COUNT(distinct cwd_user.user_name) as user_count\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id= cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'", (Object)((Object)DbType.MSSQL), (Object)"SELECT COUNT(DISTINCT dbo.cwd_user.user_name) AS user_count\nFROM dbo.cwd_group\nINNER JOIN dbo.cwd_membership ON dbo.cwd_membership.parent_id = cwd_group.id\nINNER JOIN dbo.cwd_user ON dbo.cwd_user.id = dbo.cwd_membership.child_user_id\nWHERE dbo.cwd_user.active = 'T'", (Object)((Object)DbType.ORACLE), (Object)"SELECT COUNT(distinct cwd_user.user_name)\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id= cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'", (Object)((Object)DbType.MYSQL), (Object)"SELECT COUNT(DISTINCT cwd_user.user_name) as user_count\nFROM cwd_group\nINNER JOIN cwd_membership ON cwd_membership.parent_id = cwd_group.id\nINNER JOIN cwd_user ON cwd_user.id = cwd_membership.child_user_id\nWHERE cwd_user.active = 'T'"));

    private GuardrailsQueries() {
    }

    public static final String pageDepthChildPageQuery(List<Tuple> tupleList) {
        String sqlListString = GuardrailsUtil.toSqlListString(tupleList);
        return "select CONTENTID, SPACEID FROM CONTENT WHERE PARENTID in " + sqlListString + " and CONTENT_STATUS = 'current' and PREVVER is NULL and CONTENTTYPE = 'PAGE'";
    }
}

