/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.user;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.MigrationDetailsDto;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.execution.StepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.TombstoneMappingsPublisher;
import com.atlassian.migration.agent.service.stepexecutor.TombstoneMappingsPublisherException;
import com.atlassian.migration.agent.service.stepexecutor.UsersGroupMigrationRequestData;
import com.atlassian.migration.agent.service.stepexecutor.space.TombstoneUser;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.migration.agent.service.user.TombstoneFileParameters;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.atlassian.migration.agent.service.user.UsersMigrationException;
import com.atlassian.migration.agent.service.user.UsersMigrationRequestBuilder;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationStatusResponse;
import com.atlassian.migration.agent.service.user.UsersToTombstoneFileManager;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2Request;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.agent.store.StepProgressPropertiesStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class UsersMigrationExecutor
implements StepExecutor {
    private static final String MIGRATION_ID = "migrationId";
    private static final String CLOUD_ID = "cloudId";
    private static final String TASK_ID = "taskId";
    private static final String PLAN_ID = "planId";
    private static final String MIGRATION_SCOPE_ID = "migrationScopeId";
    private static final Logger log = ContextLoggerFactory.getLogger(UsersMigrationExecutor.class);
    private static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    private static final int CONCURRENCY_LEVEL = 1;
    private static final String TOMBSTONE_USERS_MIGRATED = "tombstoneUsersMigrated";
    public static final String USERS_MIGRATION_ACTION = "usersAndGroupsMigrated";
    public static final String USERS_MIGRATION_JOB_SUBMITTED_ACTION = "usersAndGroupsMigrationJobSubmitted";
    public static final String USERS_MIGRATION_V2_REQUEST_BUILT_ACTION = "usersAndGroupsMigrationV2RequestBuilt";
    public static final String TOTAL_USERS_COUNT_PROGRESS_PROPERTY = "totalUsersCount";
    public static final String MIGRATED_USERS_COUNT_PROGRESS_PROPERTY = "migratedUsersCount";
    public static final String TOTAL_GROUPS_COUNT_PROGRESS_PROPERTY = "totalGroupsCount";
    public static final String MIGRATED_GROUPS_COUNT_PROGRESS_PROERPTY = "migratedGroupsCount";
    private final UsersMigrationService usersMigrationService;
    private final ProgressTracker progressTracker;
    private final StepStore stepStore;
    private final StepProgressPropertiesStore stepProgressPropertiesStore;
    private final UsersMigrationRequestBuilder usersMigrationRequestBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final UserMappingsFileManager userMappingsFileManager;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final Supplier<Instant> instantSupplier;
    private final PluginTransactionTemplate ptx;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    private final UsersToTombstoneFileManager usersToTombstoneFileManager;
    private final TombstoneMappingsPublisher tombstoneMappingsPublisher;
    private final ShadowMigrationExecutor shadowMigrationExecutor;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private final RetryPolicy<Void> parallelUserMigrationRetryPolicy;

    public UsersMigrationExecutor(RetryingUsersMigrationService usersMigrationService, ProgressTracker progressTracker, UsersMigrationRequestBuilder usersMigrationRequestBuilder, StepStore stepStore, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, UserMappingsFileManager userMappingsFileManager, EnterpriseGatekeeperClient enterpriseGatekeeperClient, PluginTransactionTemplate ptx, MigrationDarkFeaturesManager migrationDarkFeaturesManager, GlobalEmailFixesConfigService globalEmailFixesConfigService, UsersToTombstoneFileManager usersToTombstoneFileManager, TombstoneMappingsPublisher tombstoneMappingsPublisher, StepProgressPropertiesStore stepProgressPropertiesStore, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        this(usersMigrationService, progressTracker, usersMigrationRequestBuilder, stepStore, analyticsEventService, analyticsEventBuilder, userMappingsFileManager, enterpriseGatekeeperClient, ptx, Instant::now, migrationDarkFeaturesManager, globalEmailFixesConfigService, usersToTombstoneFileManager, tombstoneMappingsPublisher, stepProgressPropertiesStore, shadowMigrationExecutor, v4Logger, clusterInformationService);
    }

    @VisibleForTesting
    UsersMigrationExecutor(RetryingUsersMigrationService usersMigrationService, ProgressTracker progressTracker, UsersMigrationRequestBuilder usersMigrationRequestBuilder, StepStore stepStore, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, UserMappingsFileManager userMappingsFileManager, EnterpriseGatekeeperClient enterpriseGatekeeperClient, PluginTransactionTemplate ptx, Supplier<Instant> instantSupplier, MigrationDarkFeaturesManager migrationDarkFeaturesManager, GlobalEmailFixesConfigService globalEmailFixesConfigService, UsersToTombstoneFileManager usersToTombstoneFileManager, TombstoneMappingsPublisher tombstoneMappingsPublisher, StepProgressPropertiesStore stepProgressPropertiesStore, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        this.usersMigrationService = usersMigrationService;
        this.progressTracker = progressTracker;
        this.stepStore = stepStore;
        this.usersMigrationRequestBuilder = usersMigrationRequestBuilder;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.userMappingsFileManager = userMappingsFileManager;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.instantSupplier = instantSupplier;
        this.ptx = ptx;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.usersToTombstoneFileManager = usersToTombstoneFileManager;
        this.tombstoneMappingsPublisher = tombstoneMappingsPublisher;
        this.stepProgressPropertiesStore = stepProgressPropertiesStore;
        this.parallelUserMigrationRetryPolicy = RetryPolicyBuilder.policyForParallelUserMigration();
        this.shadowMigrationExecutor = shadowMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    UsersMigrationExecutorJobMetadata startUsersMigrationAndBuildJobMetadata(String stepId, Optional<PrcTask> prcTask) {
        String fileId;
        UsersMigrationV2FilePayload filePayload;
        long freeHeapSizeAtStart;
        Instant startTime;
        boolean success;
        MigrateUsersTask usersTask;
        Step jobStep;
        V4LogContext logContext;
        block9: {
            long timeTaken;
            UsersMigrationExecutorJobMetadata usersMigrationExecutorJobMetadata;
            Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
            logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
            this.v4Logger.logInfo(log, logContext, "Starting users migration and building job metadata");
            jobStep = this.stepStore.getStep(stepId);
            Plan plan = jobStep.getPlan();
            usersTask = plan.getUserTaskOfPlan().orElseThrow(() -> new IllegalStateException(String.format("UsersMigrationExecutor should not be invoked for a plan with no user migration task. StepId: %s", stepId)));
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUserMigrationStartEvent(jobStep, this.instantSupplier.get().toEpochMilli(), this.getMigrationAttributes(plan.getCloudSite().getCloudId())));
            success = false;
            startTime = this.instantSupplier.get();
            freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
            logContext.addAdditionalProperties(MIGRATION_ID, plan.getMigrationId(), CLOUD_ID, plan.getCloudSite().getCloudId(), "startTime", startTime.toString());
            try {
                try {
                    this.v4Logger.logInfo(log, logContext, "Checking for parallel users migration");
                    Failsafe.with(this.parallelUserMigrationRetryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
                        List<Step> steps = this.stepStore.stepsCurrentlyRunning(StepType.USERS_MIGRATION.name());
                        List<Step> runningParallelSteps = this.multipleStepsInUsersMigrationForCloud(steps, stepId, plan.getCloudSite().getCloudId());
                        if (!runningParallelSteps.isEmpty()) {
                            this.v4Logger.logInfo(log, logContext, String.format("Another plan is currently running users migration. Conflicting migration ID: %s", runningParallelSteps.get(0).getPlan().getMigrationId()));
                            throw new StepExecutionException(MigrationErrorCode.USER_MIGRATION_ERROR, StepType.USERS_MIGRATION, plan.getMigrationId(), "Another plan is currently running users migration.");
                        }
                        this.v4Logger.logInfo(log, logContext, "No parallel users migration detected");
                        return null;
                    });
                }
                catch (Exception e) {
                    success = MigrationErrorCode.MULTIPLE_USERS_MIGRATIONS_STEP_RUNNING.shouldBeTreatedAsGoodEventInReliabilitySlo();
                    this.v4Logger.logError(log, logContext, "Parallel users migration check failed", e);
                    throw e;
                }
                String migrationScopeId = plan.getMigrationScopeId();
                String planId = plan.getId();
                MigrationTag migrationTag = plan.getMigrationTag();
                String containerToken = plan.getCloudSite().getContainerToken();
                Set<String> spaceKeys = plan.getSpaceKeysBasedOnUserTaskInPlan();
                logContext.addAdditionalProperties(MIGRATION_SCOPE_ID, migrationScopeId, "spaceKeysCount", String.valueOf(spaceKeys.size()));
                this.v4Logger.logInfo(log, logContext, "Building users migration request data");
                this.progressTracker.progressUpdateForSubStep(stepId, 0, StepSubType.valueOf(jobStep.getSubType()).getDisplayName(), StepSubType.USERS_EXPORT.getDetailedStatus(), StepSubType.USERS_EXPORT, Collections.emptyMap(), prcTask);
                Optional<GlobalEntityType> globalEntityType = plan.getGlobalEntityTaskOfPlan();
                UsersGroupMigrationRequestData v2RequestData = this.buildUserMigrationRequestV2(migrationScopeId, plan.getMigrationId(), planId, plan.getCloudSite().getCloudId(), stepId, spaceKeys, migrationTag, plan.getMigrationProtocol(), globalEntityType, prcTask);
                filePayload = v2RequestData.getFilePayload();
                UsersMigrationV2Request v2Request = v2RequestData.getUsersMigrationV2Request();
                this.v4Logger.logInfo(log, logContext, "Users migration request data built successfully");
                if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
                    this.v4Logger.logInfo(log, logContext, "Handling global email fixes with tombstone users");
                    List<TombstoneUser> usersToTombstone = this.usersToTombstoneFileManager.getUsersToTombstoneFromFile(jobStep.getPlan().getId()).stream().map(TombstoneUser::fromMigrationUser).collect(Collectors.toList());
                    this.v4Logger.logInfo(log, logContext, String.format("Creating and publishing tombstone mappings for %d users", usersToTombstone.size()));
                    this.createAndPublishTombstoneMappings(jobStep, usersToTombstone, usersTask.isScoped());
                }
                this.progressTracker.progressUpdateForSubStep(stepId, 100, StepSubType.USERS_IMPORT.getDisplayName(), StepSubType.USERS_IMPORT.getDetailedStatus(), StepSubType.USERS_IMPORT, UsersMigrationExecutor.getUserUploadProgressProperties(filePayload), prcTask);
                MigrationProtocol migrationProtocol = plan.getMigrationProtocol();
                log.info("V2 request data path received: {}", (Object)v2Request.getData().getPath());
                fileId = Paths.get(v2Request.getData().getPath(), new String[0]).toString().replace(File.separator, ":");
                if (fileId.startsWith(":")) {
                    fileId = fileId.substring(1);
                }
                logContext.addAdditionalProperties("migrationProtocol", migrationProtocol.name());
                this.v4Logger.logInfo(log, logContext, String.format("Processing users migration file with fileId: %s", fileId));
                if (migrationProtocol != MigrationProtocol.V2 && migrationProtocol != MigrationProtocol.CV2) break block9;
                this.v4Logger.logInfo(log, logContext, "Initiating users and groups import V2");
                String taskId = this.initiateUsersAndGroupsImportV2(containerToken, filePayload, v2Request, plan);
                logContext.addAdditionalProperties(TASK_ID, taskId);
                this.v4Logger.logInfo(log, logContext, "Users migration job metadata created");
                usersMigrationExecutorJobMetadata = new UsersMigrationExecutorJobMetadata(stepId, taskId, new UsersGroupsRequestMetadata(filePayload.getUsers().size(), filePayload.getGroups().size(), usersTask.isScoped(), fileId));
                timeTaken = this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli();
            }
            catch (Throwable throwable) {
                long timeTaken2 = this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli();
                this.v4Logger.logInfo(log, logContext, String.format("Users migration job metadata creation completed in %d ms", timeTaken2));
                EventDto timerEvent = this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken2, USERS_MIGRATION_JOB_SUBMITTED_ACTION, jobStep.getPlan().getId(), usersTask.isScoped());
                this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)timerEvent, (Object)this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(jobStep, freeHeapSizeAtStart, 1, 1)));
                throw throwable;
            }
            this.v4Logger.logInfo(log, logContext, String.format("Users migration job metadata creation completed in %d ms", timeTaken));
            EventDto timerEvent = this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken, USERS_MIGRATION_JOB_SUBMITTED_ACTION, jobStep.getPlan().getId(), usersTask.isScoped());
            this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)timerEvent, (Object)this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(jobStep, freeHeapSizeAtStart, 1, 1)));
            return usersMigrationExecutorJobMetadata;
        }
        this.v4Logger.logInfo(log, logContext, "Processing V4 flow for users migration");
        if (prcTask.isPresent()) {
            logContext.addAdditionalProperties("prcTaskId", ((TransferTask)prcTask.get().getTransferTask()).getTaskId());
            this.v4Logger.logInfo(log, logContext, "Sending V4 user completion status");
            this.progressTracker.sendV4UserCompletionStatus(filePayload, fileId, prcTask.get(), "Successfully uploaded users and groups");
        } else {
            this.v4Logger.logError(log, logContext, "PrcTask is not present for step");
        }
        this.v4Logger.logInfo(log, logContext, "Users migration job metadata created");
        UsersMigrationExecutorJobMetadata usersMigrationExecutorJobMetadata = new UsersMigrationExecutorJobMetadata(stepId, "V4Flow", new UsersGroupsRequestMetadata(filePayload.getUsers().size(), filePayload.getGroups().size(), usersTask.isScoped(), fileId));
        long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli();
        this.v4Logger.logInfo(log, logContext, String.format("Users migration job metadata creation completed in %d ms", timeTaken));
        EventDto timerEvent = this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken, USERS_MIGRATION_JOB_SUBMITTED_ACTION, jobStep.getPlan().getId(), usersTask.isScoped());
        this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)timerEvent, (Object)this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(jobStep, freeHeapSizeAtStart, 1, 1)));
        return usersMigrationExecutorJobMetadata;
    }

    @VisibleForTesting
    String initiateUsersAndGroupsImportV2(String containerToken, UsersMigrationV2FilePayload filePayload, UsersMigrationV2Request request, Plan plan) {
        V4LogContext logContext = V4LogContext.builder().nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, plan.getMigrationId(), CLOUD_ID, plan.getCloudSite().getCloudId(), MIGRATION_SCOPE_ID, request.getMigrationScopeId());
        this.v4Logger.logInfo(log, logContext, String.format("Initiating users and groups import V2 with %d users and %d groups", filePayload.getUsers().size(), filePayload.getGroups().size()));
        try {
            String importTaskId = this.usersMigrationService.initiateUsersAndGroupsMigrationV2(containerToken, request);
            this.v4Logger.logInfo(log, logContext, String.format("Successfully initiated users and groups import task with taskId: %s", importTaskId));
            return importTaskId;
        }
        catch (Exception e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                this.v4Logger.logWarn(log, logContext, "Users migration initiation interrupted", e);
                throw new UncheckedInterruptedException(e);
            }
            this.v4Logger.logError(log, logContext, "Failed to initiate users and groups import task", e);
            this.sendErrorOperationalEvent(plan.getMigrationId(), plan.getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()), Optional.empty());
            throw new UsersMigrationException("Failed to initiate users and groups import task for migration " + plan.getMigrationId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Optional<StepResult> doProgressCheck(UsersMigrationExecutorJobMetadata jobMetadata) {
        UsersMigrationStatusResponse response;
        String stepId = jobMetadata.stepId;
        String taskId = jobMetadata.taskId;
        UsersGroupsRequestMetadata requestMetadata = jobMetadata.requestMetadata;
        Step step = this.stepStore.getStep(stepId);
        Plan plan = step.getPlan();
        CloudSite cloudSite = plan.getCloudSite();
        String containerToken = cloudSite.getContainerToken();
        String cloudId = cloudSite.getCloudId();
        String planId = plan.getId();
        String migrationScopeId = plan.getMigrationScopeId();
        ExecutionStatus planStatus = plan.getProgress().getStatus();
        String migrationId = plan.getMigrationId();
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, CLOUD_ID, cloudId, PLAN_ID, planId, MIGRATION_SCOPE_ID, migrationScopeId, TASK_ID, taskId);
        if (planStatus == ExecutionStatus.STOPPING || planStatus == ExecutionStatus.STOPPED) {
            this.v4Logger.logInfo(log, logContext, "Plan is stopping, handling plan stop for users migration");
            this.handlePlanStop(containerToken, taskId, step, plan, requestMetadata);
            return Optional.of(StepResult.stopped());
        }
        try {
            this.v4Logger.logInfo(log, logContext, "Checking users migration progress");
            response = this.usersMigrationService.getUsersAndGroupsMigrationProgress(containerToken, taskId);
            this.v4Logger.logDebug(log, logContext, String.format("Got progress for users migration - progress: %d%%, complete: %s, successful: %s", response.getProgressPercentage(), response.isComplete(), response.isSuccessful()));
        }
        catch (Exception e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                this.v4Logger.logWarn(log, logContext, "Users migration progress check interrupted", e);
                throw new UncheckedInterruptedException(e);
            }
            this.v4Logger.logError(log, logContext, "Failed to get users migration progress", e);
            this.sendErrorOperationalEvent(migrationId, cloudId, Optional.ofNullable(e.getMessage()), Optional.of(taskId));
            throw new StepExecutionException(MigrationErrorCode.USER_MIGRATION_ERROR, StepType.USERS_MIGRATION, plan.getMigrationId(), "Failed to get users and groups migration progress");
        }
        Map<String, Object> userImportProgressProperties = this.buildUserImportProgressProperties(step, response);
        if (!response.isComplete()) {
            log.debug("Users and groups migration to cloud is still going. Updated progress for task {} to {} for migrationId: {}.", new Object[]{taskId, response.getProgressPercentage(), migrationId});
            this.progressTracker.progressUpdateForSubStep(stepId, response.getProgressPercentage(), step.getDisplayName(), StepSubType.USERS_IMPORT.getDetailedStatus(), StepSubType.USERS_IMPORT, userImportProgressProperties, Optional.empty());
            return Optional.empty();
        }
        boolean success = false;
        try {
            if (!response.isSuccessful()) {
                success = MigrationErrorCode.USER_MIGRATION_ERROR.shouldBeTreatedAsGoodEventInReliabilitySlo();
                ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(MigrationErrorCode.USER_MIGRATION_ERROR, MigrationErrorCode.USER_MIGRATION_ERROR.getContainerType(), plan.getMigrationId(), StepType.USERS_MIGRATION).setCloudid(cloudId).setReason(response.getErrorMessages().toString()).build();
                ImmutableList metrics = ImmutableList.of((Object)this.analyticsEventBuilder.buildErrorOperationalEventWithImportTaskId(errorEvent, Optional.of(taskId)));
                this.analyticsEventService.sendAnalyticsEvents(() -> UsersMigrationExecutor.lambda$doProgressCheck$5((List)metrics));
                log.error("Users and groups migration failed for task: {} with errors: {} for migrationId: {}", new Object[]{taskId, response.getErrors(), migrationId});
                throw new StepExecutionException(MigrationErrorCode.USER_MIGRATION_ERROR, StepType.USERS_MIGRATION, plan.getMigrationId(), response.getFirstErrorMessage().orElse("Unknown error"));
            }
            this.getUserMappingsAndSaveToFile(cloudId, planId, migrationScopeId);
            this.progressTracker.updateProgressPropertiesWithoutTransferUpdate(stepId, userImportProgressProperties);
            success = true;
            Optional<StepResult> optional = Optional.of(StepResult.succeeded("Users and groups migration complete"));
            return optional;
        }
        finally {
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step));
            this.saveTimerEvent(USERS_MIGRATION_ACTION, success, this.getStepTime(step), planId, requestMetadata);
        }
    }

    private Map<String, Object> buildUserImportProgressProperties(Step step, UsersMigrationStatusResponse response) {
        int totalUsers = response.getTotalUsersCount();
        int totalGroups = response.getTotalGroupsCount();
        Map previousProgressProperties = this.ptx.read(() -> this.stepProgressPropertiesStore.getStepProgressProperties(step.getId()));
        if (response.getTotalUsersCount() == 0) {
            totalUsers = previousProgressProperties.getOrDefault(TOTAL_USERS_COUNT_PROGRESS_PROPERTY, 0);
            totalGroups = previousProgressProperties.getOrDefault(TOTAL_GROUPS_COUNT_PROGRESS_PROPERTY, 0);
        }
        return ImmutableMap.builder().put((Object)TOTAL_USERS_COUNT_PROGRESS_PROPERTY, (Object)totalUsers).put((Object)MIGRATED_USERS_COUNT_PROGRESS_PROPERTY, (Object)response.getMigratedUsersCount()).put((Object)TOTAL_GROUPS_COUNT_PROGRESS_PROPERTY, (Object)totalGroups).put((Object)MIGRATED_GROUPS_COUNT_PROGRESS_PROERPTY, (Object)response.getMigratedGroupsCount()).build();
    }

    private static Map<String, Object> getUserUploadProgressProperties(UsersMigrationV2FilePayload filePayload) {
        return ImmutableMap.builder().put((Object)TOTAL_USERS_COUNT_PROGRESS_PROPERTY, (Object)filePayload.getUsers().size()).put((Object)MIGRATED_USERS_COUNT_PROGRESS_PROPERTY, (Object)0).put((Object)TOTAL_GROUPS_COUNT_PROGRESS_PROPERTY, (Object)filePayload.getGroups().size()).put((Object)MIGRATED_GROUPS_COUNT_PROGRESS_PROERPTY, (Object)0).build();
    }

    private List<TombstoneUser> createAndPublishTombstoneMappings(Step step, List<TombstoneUser> tombstoneUsers, boolean scoped) {
        Instant startTime = this.instantSupplier.get();
        try {
            List<TombstoneUser> tombstoneUsersWithAaids = this.tombstoneMappingsPublisher.createAndPublishTombstoneMappings(step, tombstoneUsers);
            this.saveTimerEvent(TOMBSTONE_USERS_MIGRATED, true, this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli(), step.getPlan().getId(), scoped, tombstoneUsers.size());
            return tombstoneUsersWithAaids;
        }
        catch (TombstoneMappingsPublisherException e) {
            this.saveTimerEvent(TOMBSTONE_USERS_MIGRATED, false, this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli(), step.getPlan().getId(), scoped, tombstoneUsers.size());
            this.sendErrorOperationalEvent(step.getPlan().getMigrationId(), step.getPlan().getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()), Optional.empty());
            throw new StepExecutionException(MigrationErrorCode.CREATE_AND_PUBLISHING_TOMBSTONE_MAPPINGS, StepType.USERS_MIGRATION, step.getPlan().getMigrationId(), e.getMessage(), e);
        }
    }

    private Map<String, String> getUserMappingsAndSaveToFile(String cloudId, String planId, String migrationScopeId) {
        try {
            UserMappingsManager userMappingsManager = new UserMappingsManager(this.migrationDarkFeaturesManager, this.enterpriseGatekeeperClient, cloudId, migrationScopeId);
            Map<String, String> mappings = userMappingsManager.getMappings();
            this.userMappingsFileManager.saveToFile(planId, mappings);
            return mappings;
        }
        catch (RuntimeException e) {
            log.error("Error getUserMappingsAndSaveToFile: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyMap();
        }
    }

    @VisibleForTesting
    UsersGroupMigrationRequestData buildUserMigrationRequestV2(String migrationScopeId, String migrationId, String planId, String cloudId, String stepId, Set<String> spaceKeys, MigrationTag migrationTag, MigrationProtocol migrationProtocol, Optional<GlobalEntityType> globalEntityType, Optional<PrcTask> prcTask) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, CLOUD_ID, cloudId, PLAN_ID, planId, MIGRATION_SCOPE_ID, migrationScopeId);
        this.v4Logger.logInfo(log, logContext, String.format("Building users migration request V2 for %d space keys.", spaceKeys.size()));
        Instant startTime = this.instantSupplier.get();
        boolean scoped = !spaceKeys.isEmpty();
        try {
            UsersMigrationV2FilePayload filePayload = this.usersMigrationRequestBuilder.createUsersMigrationRequestV2FilePayload(spaceKeys, cloudId, TombstoneFileParameters.withFile(planId), globalEntityType);
            this.progressTracker.progressUpdateForSubStep(stepId, 100, StepSubType.USERS_UPLOAD.getDisplayName(), StepSubType.USERS_UPLOAD.getDetailedStatus(), StepSubType.USERS_UPLOAD, Collections.emptyMap(), prcTask);
            this.v4Logger.logInfo(log, logContext, "Creating users migration request V2 payload");
            UsersMigrationV2Request requestPayload = this.usersMigrationRequestBuilder.createUsersMigrationRequestV2(migrationScopeId, migrationId, planId, cloudId, filePayload);
            long timeTaken = this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli();
            this.v4Logger.logInfo(log, logContext, String.format("Successfully built users migration request V2 in %d ms", timeTaken));
            this.saveTimerEvent(USERS_MIGRATION_V2_REQUEST_BUILT_ACTION, true, timeTaken, planId, scoped, filePayload.getUsers().size(), filePayload.getGroups().size());
            this.sendUserExportStepCompletionPlatformEvents(migrationId, stepId, migrationScopeId, planId, cloudId, ExecutionStatus.DONE, migrationTag, migrationProtocol);
            return new UsersGroupMigrationRequestData(filePayload, requestPayload);
        }
        catch (Exception e) {
            this.v4Logger.logError(log, logContext, "Error building users migration request", e);
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                throw new UncheckedInterruptedException(e);
            }
            this.saveTimerEvent(USERS_MIGRATION_V2_REQUEST_BUILT_ACTION, false, this.instantSupplier.get().toEpochMilli() - startTime.toEpochMilli(), planId, scoped);
            this.sendUserExportStepCompletionPlatformEvents(migrationId, stepId, migrationScopeId, planId, cloudId, ExecutionStatus.FAILED, migrationTag, migrationProtocol);
            this.sendErrorOperationalEvent(migrationId, cloudId, Optional.ofNullable(e.getMessage()), Optional.empty());
            throw new StepExecutionException(MigrationErrorCode.USER_MIGRATION_ERROR, StepType.USERS_MIGRATION, migrationId, "Couldn't retrieve entities to build request", e);
        }
    }

    private void saveTimerEvent(String action, boolean success, long timeTaken, String planId, UsersGroupsRequestMetadata requestMetadata) {
        this.saveTimerEvent(action, success, timeTaken, planId, requestMetadata.scoped, requestMetadata.userCount, requestMetadata.groupCount);
    }

    private void saveTimerEvent(String action, boolean success, long timeTaken, String planId, boolean scoped, int userCount, int groupCount) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken, action, planId, scoped, userCount, groupCount));
    }

    private void saveTimerEvent(String action, boolean success, long timeTaken, String planId, boolean scoped, int userCount) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken, action, planId, scoped, userCount, -1));
    }

    private void sendUserExportStepCompletionPlatformEvents(String migrationId, String stepId, String migrationScopeId, String planId, String cloudId, ExecutionStatus status, MigrationTag migrationTag, MigrationProtocol migrationProtocol) {
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildPlatformStepCompletionOperationalEventUtil(new MigrationDetailsDto(migrationId, migrationScopeId, planId, cloudId, stepId, migrationProtocol.name()), Optional.empty(), "USER_EXPORT", status, migrationTag), (Object)this.analyticsEventBuilder.buildPlatformStepCompletionExtendedMetricEvent("USER_EXPORT", status, migrationTag)));
    }

    private void sendErrorOperationalEvent(String migrationId, String cloudId, Optional<String> errorReason, Optional<String> taskId) {
        String reason = errorReason.orElse("");
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(MigrationErrorCode.USER_MIGRATION_ERROR, MigrationErrorCode.USER_MIGRATION_ERROR.getContainerType(), migrationId, StepType.USERS_MIGRATION).setCloudid(cloudId).setReason(reason).build();
        this.analyticsEventService.sendAnalyticsEvent(() -> this.analyticsEventBuilder.buildErrorOperationalEventWithImportTaskId(errorEvent, taskId));
    }

    private void saveTimerEvent(String action, boolean success, long timeTaken, String planId, boolean scoped) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUserStepTimerEvent(success, timeTaken, action, planId, scoped));
    }

    private long getStepTime(Step step) {
        Progress progress = step.getProgress();
        if (progress != null && progress.getStartTime().isPresent()) {
            return this.instantSupplier.get().toEpochMilli() - progress.getStartTime().get().toEpochMilli();
        }
        return -1L;
    }

    private List<Step> multipleStepsInUsersMigrationForCloud(List<Step> steps, String stepId, String cloudId) {
        return steps.stream().filter(step -> !stepId.equals(step.getId()) && cloudId.equals(step.getPlan().getCloudSite().getCloudId())).collect(Collectors.toList());
    }

    @VisibleForTesting
    ImmutableMap.Builder<String, Object> getMigrationAttributes(String cloudId) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"tenantId", (Object)cloudId);
        Optional.ofNullable(this.globalEmailFixesConfigService.getConfirmedUdcModeConfig()).ifPresent(udcMode -> attributes.put((Object)"udcMode", (Object)udcMode.name()));
        if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            attributes.put((Object)"invalidEmailsConfig", (Object)this.globalEmailFixesConfigService.getInvalidEmailsConfig().getActionOnMigration().name());
            attributes.put((Object)"duplicateEmailsConfig", (Object)this.globalEmailFixesConfigService.getDuplicateEmailsConfig().getActionOnMigration().name());
        }
        return attributes;
    }

    @Override
    public StepType getStepType() {
        return StepType.USERS_MIGRATION;
    }

    @Override
    public StepResult runStep(String stepId) {
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(this.getStepType().name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        this.v4Logger.logInfo(log, logContext, "Starting step");
        return this.doExportUpload(stepId, Optional.empty());
    }

    public StepResult doExportUpload(String stepId, Optional<PrcTask> prcTask) {
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(this.getStepType().name()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        this.v4Logger.logInfo(log, logContext, "Starting users migration export");
        if (prcTask.isPresent() && this.shadowMigrationExecutor.isShadowMigration(this.stepStore.getStep(stepId))) {
            this.v4Logger.logInfo(log, logContext, "Performing shadow migration for users");
            return this.shadowMigrationExecutor.performShadowMigration(stepId, prcTask.get());
        }
        UsersMigrationExecutorJobMetadata jobMetadata = null;
        Step step = null;
        try {
            step = this.ptx.read(() -> this.stepStore.getStep(stepId));
            String executionState = step.getExecutionState();
            MigrationProtocol migrationProtocol = step.getPlan().getMigrationProtocol();
            logContext.addAdditionalProperties(MIGRATION_ID, step.getPlan().getMigrationId(), CLOUD_ID, step.getPlan().getCloudSite().getCloudId(), "migrationProtocol", migrationProtocol.name());
            this.v4Logger.logInfo(log, logContext, "Invoking Users Migration Export and Upload");
            if (StringUtils.isNotEmpty((CharSequence)executionState)) {
                this.v4Logger.logInfo(log, logContext, "Resuming previous users migration execution");
                jobMetadata = Jsons.readValue(executionState, UsersMigrationExecutorJobMetadata.class);
            } else {
                this.v4Logger.logInfo(log, logContext, "Starting new users migration execution");
                UsersMigrationExecutorJobMetadata metadata = this.startUsersMigrationAndBuildJobMetadata(stepId, prcTask);
                this.ptx.write(() -> {
                    Step stepUpdated = this.stepStore.getStep(stepId);
                    stepUpdated.setExecutionState(Jsons.valueAsString(metadata));
                    this.stepStore.update(stepUpdated);
                });
                jobMetadata = metadata;
            }
            if (migrationProtocol == MigrationProtocol.V2 || migrationProtocol == MigrationProtocol.CV2) {
                Optional<StepResult> result;
                while (!(result = this.doProgressCheck(jobMetadata)).isPresent()) {
                    Thread.sleep(POLLING_PERIOD.toMillis());
                }
                this.v4Logger.logInfo(log, logContext, "Users migration V2/CV2 processing completed");
                return result.get();
            }
            this.v4Logger.logInfo(log, logContext, "Users migration V4 flow completed successfully");
            return StepResult.succeeded("Exported & Uploaded Users And Groups via V4 Flow");
        }
        catch (UncheckedInterruptedException | InterruptedException e) {
            this.v4Logger.logWarn(log, logContext, "Users migration interrupted", e);
            if (jobMetadata != null) {
                this.handlePlanStop(jobMetadata);
            }
            if (this.checkIfPlanIsStopped(stepId)) {
                this.v4Logger.logInfo(log, logContext, "Users migration stopped due to plan stop");
                this.sendUserFailureStatusToPrc(Optional.of(step), prcTask, CommandStatus.CANCELLED, "Plan was stopped");
                return StepResult.stopped();
            }
            StepResult result = StepResult.failed(String.format("An unexpected error occurred during step: %s. Error: %s", this.getStepType(), e.getMessage()), e);
            this.v4Logger.logError(log, logContext, "Users migration failed due to interruption", e);
            this.sendUserFailureStatusToPrc(Optional.of(step), prcTask, CommandStatus.FAILED, result.getMessage());
            return result;
        }
        catch (Exception e) {
            if (this.checkIfPlanIsStopped(stepId)) {
                return StepResult.stopped();
            }
            StepResult result = StepResult.failed(String.format("An unexpected error occurred during step: %s. Error: %s", this.getStepType(), e.getMessage()), e);
            this.v4Logger.logError(log, logContext, "An error occurred while running step", e);
            this.sendUserFailureStatusToPrc(Optional.of(step), prcTask, CommandStatus.FAILED, result.getMessage());
            return result;
        }
    }

    private void sendUserFailureStatusToPrc(Optional<Step> step, Optional<PrcTask> prcTask, CommandStatus commandStatus, String statusMessage) {
        if (step.isPresent() && step.get().getPlan().getMigrationProtocol().equals((Object)MigrationProtocol.V4)) {
            if (prcTask.isPresent()) {
                this.progressTracker.sendV4UserFailureStatus(prcTask.get(), commandStatus, statusMessage);
            } else {
                log.warn("No PRC task present for step: {}", (Object)step.get().getId());
            }
        }
    }

    private boolean checkIfPlanIsStopped(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        ExecutionStatus planStatus = step.getPlan().getProgress().getStatus();
        return planStatus == ExecutionStatus.STOPPING || planStatus == ExecutionStatus.STOPPED;
    }

    private void handlePlanStop(UsersMigrationExecutorJobMetadata jobMetadata) {
        String taskId = jobMetadata.getTaskId();
        UsersGroupsRequestMetadata requestMetadata = jobMetadata.getRequestMetadata();
        String stepId = jobMetadata.getStepId();
        Step step = this.stepStore.getStep(stepId);
        Plan plan = step.getPlan();
        CloudSite cloudSite = plan.getCloudSite();
        String containerToken = cloudSite.getContainerToken();
        this.handlePlanStop(containerToken, taskId, step, plan, requestMetadata);
    }

    private void handlePlanStop(String containerToken, String taskId, Step step, Plan plan, UsersGroupsRequestMetadata requestMetadata) {
        String planId = plan.getId();
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, plan.getMigrationId(), CLOUD_ID, plan.getCloudSite().getCloudId(), PLAN_ID, planId, TASK_ID, taskId);
        this.v4Logger.logInfo(log, logContext, "User migration was stopped");
        try {
            if (this.isUMSMigrationInProgress(containerToken, taskId)) {
                this.v4Logger.logInfo(log, logContext, String.format("There was a running users & groups migration in UMS, cancelling with containerToken: %s", containerToken));
                this.usersMigrationService.cancelUsersAndGroupsMigration(containerToken, taskId);
            } else {
                this.v4Logger.logInfo(log, logContext, String.format("User migration was stopped but users & groups migration has already reached a terminal state with containerToken: %s", containerToken));
            }
            this.saveTimerEvent(USERS_MIGRATION_ACTION, false, this.getStepTime(step), planId, requestMetadata);
        }
        catch (Exception e) {
            this.sendErrorOperationalEvent(plan.getMigrationId(), plan.getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()), Optional.of(taskId));
            throw new StepExecutionException(MigrationErrorCode.USER_MIGRATION_ERROR, StepType.USERS_MIGRATION, plan.getMigrationId(), "Failed to cancel users and groups migration", e);
        }
    }

    private boolean isUMSMigrationInProgress(String containerToken, String taskId) {
        UsersMigrationStatusResponse response = this.usersMigrationService.getUsersAndGroupsMigrationProgress(containerToken, taskId);
        return !response.isComplete();
    }

    private static /* synthetic */ Collection lambda$doProgressCheck$5(List metrics) {
        return metrics;
    }

    public static class UsersMigrationExecutorJobMetadata
    implements Serializable {
        private final String stepId;
        private final String taskId;
        private final UsersGroupsRequestMetadata requestMetadata;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public UsersMigrationExecutorJobMetadata(@org.codehaus.jackson.annotate.JsonProperty(value="stepId") @JsonProperty(value="stepId") String stepId, @org.codehaus.jackson.annotate.JsonProperty(value="taskId") @JsonProperty(value="taskId") String taskId, @org.codehaus.jackson.annotate.JsonProperty(value="requestMetadata") @JsonProperty(value="requestMetadata") UsersGroupsRequestMetadata requestMetadata) {
            this.stepId = stepId;
            this.taskId = taskId;
            this.requestMetadata = requestMetadata;
        }

        @Generated
        public String getStepId() {
            return this.stepId;
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public UsersGroupsRequestMetadata getRequestMetadata() {
            return this.requestMetadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsersMigrationExecutorJobMetadata)) {
                return false;
            }
            UsersMigrationExecutorJobMetadata other = (UsersMigrationExecutorJobMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$stepId = this.getStepId();
            String other$stepId = other.getStepId();
            if (this$stepId == null ? other$stepId != null : !this$stepId.equals(other$stepId)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            UsersGroupsRequestMetadata this$requestMetadata = this.getRequestMetadata();
            UsersGroupsRequestMetadata other$requestMetadata = other.getRequestMetadata();
            return !(this$requestMetadata == null ? other$requestMetadata != null : !((Object)this$requestMetadata).equals(other$requestMetadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsersMigrationExecutorJobMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $stepId = this.getStepId();
            result = result * 59 + ($stepId == null ? 43 : $stepId.hashCode());
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            UsersGroupsRequestMetadata $requestMetadata = this.getRequestMetadata();
            result = result * 59 + ($requestMetadata == null ? 43 : ((Object)$requestMetadata).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UsersMigrationExecutor.UsersMigrationExecutorJobMetadata(stepId=" + this.getStepId() + ", taskId=" + this.getTaskId() + ", requestMetadata=" + this.getRequestMetadata() + ")";
        }
    }

    public static class UsersGroupsRequestMetadata
    implements Serializable {
        private final int userCount;
        private final int groupCount;
        private final boolean scoped;
        private final String fileId;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public UsersGroupsRequestMetadata(@org.codehaus.jackson.annotate.JsonProperty(value="userCount") @JsonProperty(value="userCount") int userCount, @org.codehaus.jackson.annotate.JsonProperty(value="groupCount") @JsonProperty(value="groupCount") int groupCount, @org.codehaus.jackson.annotate.JsonProperty(value="scoped") @JsonProperty(value="scoped") boolean scoped, @org.codehaus.jackson.annotate.JsonProperty(value="fileId") @JsonProperty(value="fileId") @Nullable String fileId) {
            this.userCount = userCount;
            this.groupCount = groupCount;
            this.scoped = scoped;
            this.fileId = fileId;
        }

        @Generated
        public int getUserCount() {
            return this.userCount;
        }

        @Generated
        public int getGroupCount() {
            return this.groupCount;
        }

        @Generated
        public boolean isScoped() {
            return this.scoped;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsersGroupsRequestMetadata)) {
                return false;
            }
            UsersGroupsRequestMetadata other = (UsersGroupsRequestMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserCount() != other.getUserCount()) {
                return false;
            }
            if (this.getGroupCount() != other.getGroupCount()) {
                return false;
            }
            if (this.isScoped() != other.isScoped()) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsersGroupsRequestMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getUserCount();
            result = result * 59 + this.getGroupCount();
            result = result * 59 + (this.isScoped() ? 79 : 97);
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UsersMigrationExecutor.UsersGroupsRequestMetadata(userCount=" + this.getUserCount() + ", groupCount=" + this.getGroupCount() + ", scoped=" + this.isScoped() + ", fileId=" + this.getFileId() + ")";
        }
    }
}

