/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentJobProgressService;
import com.atlassian.migration.agent.service.guardrails.AssessmentQueries;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.service.guardrails.InfrastructureAssessmentStore;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentCSVService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.InstanceMetadataCollector;
import com.atlassian.migration.agent.service.guardrails.remote.CloudAssessmentCommunicationService;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.migration.agent.service.guardrails.remote.SafeExceptionReporter;
import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.scheduler.SchedulerServiceException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class InstanceAssessmentUploadService {
    private static final Logger log = LoggerFactory.getLogger(InstanceAssessmentUploadService.class);
    private static final DateTimeFormatter ZIP_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final InstanceAssessmentCSVService instanceAssessmentCSVService;
    private final AssessmentJobProgressService assessmentJobProgressService;
    private final InstanceMetadataCollector instanceMetadataCollector;
    private final InfrastructureAssessmentStore infrastructureAssessmentStore;
    private final AssessmentQueries assessmentQueries;
    private final Clock clock;
    private final TimeZoneManager timeZoneManager;
    private final PluginVersionManager pluginVersionManager;
    private final CloudAssessmentCommunicationService cloudAssessmentCommunicationService;
    private final SafeExceptionReporter safeExceptionReporter;

    public void failInCloud(CloudJobType jobType, Throwable throwable) throws IOException, CloudRequestServiceNotAvailableException {
        this.cloudAssessmentCommunicationService.failInCloud(jobType, throwable);
    }

    public void cancelInCloud(CloudJobType jobType) throws IOException, CloudRequestServiceNotAvailableException {
        this.cloudAssessmentCommunicationService.cancelInCloud(jobType);
    }

    public void runAssessments(CloudJobType jobType, InstanceAssessmentConfig config) throws SchedulerServiceException {
        if (Objects.requireNonNull(jobType) != CloudJobType.ASSESSMENT) {
            throw new IllegalArgumentException("Unknown job type: " + (Object)((Object)jobType));
        }
        this.assessmentJobProgressService.scheduleInstanceAssessment(true, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAndUploadAssessmentZip() throws IOException, CloudRequestServiceNotAvailableException {
        Instant now = this.clock.instant();
        LocalDate today = now.atZone(this.timeZoneManager.getDefaultTimeZone().toZoneId()).toLocalDate();
        String zipDate = ZIP_DATE_FORMATTER.format(today);
        Path zipPath = this.createZipFile();
        try (OutputStream outputStream = Files.newOutputStream(zipPath.toFile().toPath(), new OpenOption[0]);){
            GuardrailsCsvOutputStreamResult result = this.instanceAssessmentCSVService.generate(today, zipDate, outputStream);
            if (result.getError() != null) {
                throw new IOException("Failed to generate ZIP file: " + result.getError().getMessage(), result.getError());
            }
            log.info("Uploading Assessment");
            CloudResponse<String> cloudResponse = this.cloudAssessmentCommunicationService.sendFinishAssessmentRequest(CloudJobType.ASSESSMENT, zipPath.toFile());
            this.validateResponse(cloudResponse, HttpStatus.ACCEPTED.value());
        }
        finally {
            Files.deleteIfExists(zipPath);
        }
    }

    public void runDiscover(CloudJobType jobType) throws IOException, CloudRequestServiceNotAvailableException {
        if (Objects.requireNonNull(jobType) != CloudJobType.APP_LINKS_DISCOVERY) {
            throw new IllegalArgumentException("Unknown job type: " + (Object)((Object)jobType));
        }
        this.runDiscover(jobType, QueryIds.APP_LINKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDiscover(CloudJobType cloudJobType, QueryIds queryId) throws IOException, CloudRequestServiceNotAvailableException {
        Path zipPath = this.createZipFile();
        try {
            Instant now = this.clock.instant();
            LocalDate today = now.atZone(this.timeZoneManager.getDefaultTimeZone().toZoneId()).toLocalDate();
            InstanceMetadataDto instanceMetadataDto = this.instanceMetadataCollector.collectMetadata(now);
            ZipBuilder zipBuilder = this.instanceAssessmentCSVService.createZipBuilder(Files.newOutputStream(zipPath.toFile().toPath(), new OpenOption[0]));
            this.assessmentQueries.addSeparateFile(queryId, this.createZipDate(today), instanceMetadataDto, zipBuilder);
            zipBuilder.add(this.infrastructureAssessmentStore.getInstanceAssessmentPath(today, new InstanceAssessmentResult(instanceMetadataDto, null, this.pluginVersionManager.getPluginVersion())));
            zipBuilder.create(true);
            CloudResponse<String> cloudResponse = this.cloudAssessmentCommunicationService.sendFinishAssessmentRequest(cloudJobType, zipPath.toFile());
            this.validateResponse(cloudResponse, HttpStatus.ACCEPTED.value());
        }
        finally {
            Files.deleteIfExists(zipPath);
        }
    }

    private Path createZipFile() throws IOException {
        Path zipPath = this.instanceAssessmentCSVService.getPath().resolve("assessment-" + UUID.randomUUID());
        Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
        Files.createFile(zipPath, new FileAttribute[0]);
        return zipPath;
    }

    public boolean isConnected() {
        return this.cloudAssessmentCommunicationService.isConnected();
    }

    private void validateResponse(CloudResponse<String> cloudResponse, int expectedStatus) {
        if (cloudResponse.getStatusCode() != expectedStatus) {
            throw new WebApplicationException(Response.status((int)cloudResponse.getStatusCode()).entity(cloudResponse.getBody()).build());
        }
    }

    private String createZipDate(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return formatter.format(date);
    }

    @Generated
    public InstanceAssessmentUploadService(InstanceAssessmentCSVService instanceAssessmentCSVService, AssessmentJobProgressService assessmentJobProgressService, InstanceMetadataCollector instanceMetadataCollector, InfrastructureAssessmentStore infrastructureAssessmentStore, AssessmentQueries assessmentQueries, Clock clock, TimeZoneManager timeZoneManager, PluginVersionManager pluginVersionManager, CloudAssessmentCommunicationService cloudAssessmentCommunicationService, SafeExceptionReporter safeExceptionReporter) {
        this.instanceAssessmentCSVService = instanceAssessmentCSVService;
        this.assessmentJobProgressService = assessmentJobProgressService;
        this.instanceMetadataCollector = instanceMetadataCollector;
        this.infrastructureAssessmentStore = infrastructureAssessmentStore;
        this.assessmentQueries = assessmentQueries;
        this.clock = clock;
        this.timeZoneManager = timeZoneManager;
        this.pluginVersionManager = pluginVersionManager;
        this.cloudAssessmentCommunicationService = cloudAssessmentCommunicationService;
        this.safeExceptionReporter = safeExceptionReporter;
    }
}

