/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.UsersGroupsUploadTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class UserUploadProcessor
extends AbstractProcessor<UsersGroupsUploadTask> {
    private final UsersMigrationExecutor usersMigrationExecutor;
    private final Step prcStep;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private static final Logger log = ContextLoggerFactory.getLogger(UserUploadProcessor.class);

    public UserUploadProcessor(PrcTask<UsersGroupsUploadTask> prcTask, UsersMigrationExecutor usersMigrationExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, Step prcStep, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(prcTask, prcPoller, pollerConfigHandler, migrationLogService);
        this.usersMigrationExecutor = usersMigrationExecutor;
        this.prcStep = prcStep;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @VisibleForTesting
    UserUploadProcessor(PrcTask<UsersGroupsUploadTask> prcTask, UsersMigrationExecutor usersMigrationExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, Step prcStep, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(prcTask, prcPoller, pollerConfigHandler, heartbeatScheduler, migrationLogService);
        this.usersMigrationExecutor = usersMigrationExecutor;
        this.prcStep = prcStep;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @Override
    protected Pair<Step, StepResult> process() {
        V4LogContext logContext = V4LogContext.builder().stepId(this.prcStep.getId()).stepType(StepType.USERS_MIGRATION.name()).prcTaskId(((UsersGroupsUploadTask)this.prcTask.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(this.prcStep.getNodeExecutionId()).executionState(this.prcStep.getExecutionState()).build();
        this.v4Logger.logInfo(log, logContext, "Processing V4 user upload");
        this.setProgressStartTime(this.prcStep, StepType.USERS_MIGRATION);
        StepResult result = this.usersMigrationExecutor.doExportUpload(this.prcStep.getId(), Optional.of(this.prcTask));
        return Pair.of((Object)this.prcStep, (Object)result);
    }
}

