/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.migration;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4PollerContext;
import com.atlassian.migration.agent.service.check.V4PollerLogger;
import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.pollers.AbstractPoller;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.pollers.PollerFactory;
import com.atlassian.migration.agent.v4.pollers.StatusPoller;
import com.atlassian.migration.agent.v4.pollers.V4Poller;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;

public class MigrationTracker {
    private final PollerFactory pollerFactory;
    private final ExecutorService executor;
    private final List<AbstractPoller> registeredPollers;
    private InProgressMigrationIds inProgressMigrationIds;
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationTracker.class);
    private final V4PollerLogger v4PollerLogger;
    private final ClusterInformationService clusterInformationService;

    public MigrationTracker(PollerFactory pollerFactory, InProgressMigrationIds inProgressMigrationIds, V4PollerLogger v4PollerLogger, ClusterInformationService clusterInformationService) {
        this.pollerFactory = pollerFactory;
        this.inProgressMigrationIds = inProgressMigrationIds;
        this.v4PollerLogger = v4PollerLogger;
        this.clusterInformationService = clusterInformationService;
        this.registeredPollers = new LinkedList<AbstractPoller>();
        this.executor = Executors.newCachedThreadPool(new GroupedThreadFactory("MigrationTracker"));
    }

    public <T extends TransferTask> void addAndStartWorkPoller(PollerConfig config, V4Worker<T> worker) {
        for (int parallel = 0; parallel < config.getParallelism(); ++parallel) {
            V4Poller<T> poller = this.pollerFactory.createWorkPoller(config, worker);
            V4PollerContext context = V4PollerContext.builder().pollerId(poller.getPollerId()).nodeId(this.clusterInformationService.getCurrentNodeId()).inprogressMigrationIds(this.inProgressMigrationIds.sequence()).build();
            this.v4PollerLogger.logInfo(log, context, "Creating task poller");
            this.registeredPollers.add(poller);
            this.executor.submit(poller::startPolling);
        }
    }

    public void addAndStartStatusPoller(PollerConfig config) {
        StatusPoller statusPoller = this.pollerFactory.createStatusPoller(config, this.inProgressMigrationIds);
        V4PollerContext context = V4PollerContext.builder().pollerId(statusPoller.getPollerId()).nodeId(this.clusterInformationService.getCurrentNodeId()).inprogressMigrationIds(this.inProgressMigrationIds.sequence()).build();
        this.v4PollerLogger.logInfo(log, context, "Creating status poller");
        this.registeredPollers.add(statusPoller);
        this.executor.submit(() -> statusPoller.startPolling());
    }

    @PreDestroy
    void preDestroy() {
        log.info("Shutting down pollers");
        this.executor.shutdownNow();
    }

    public void clearInProgressMigrationIds() {
        this.inProgressMigrationIds.clear();
    }
}

