/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkAppType;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkDto;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkTargetEnv;
import com.google.common.primitives.Ints;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentApplinkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssessmentApplinkService.class);
    private static final EnumSet<ApplinkAppType> CLOUD_ONLY_APPS = EnumSet.of(ApplinkAppType.STASH);
    private static final EnumSet<ApplinkAppType> ON_PREMISE_ONLY_APPS = EnumSet.of(ApplinkAppType.BITBUCKET, ApplinkAppType.CROWD, ApplinkAppType.FISHEYE);
    private final ApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private static final int MIN_CLOUD_MAJOR_VERSION = 1000;

    public List<ApplinkDto> getApplinks() {
        return StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).map(this::toDto).collect(Collectors.toList());
    }

    private ApplinkDto toDto(ApplicationLink applink) {
        Manifest manifest = this.getManifest(applink);
        ApplinkAppType appType = ApplinkAppType.from(applink);
        ApplinkTargetEnv targetEnv = this.getTargetEnv(applink, appType, manifest);
        return ApplinkDto.builder().applinkId(applink.getId().get()).appRpcUrl(applink.getRpcUrl().toString()).appType(appType).targetEnv(targetEnv).version(targetEnv == ApplinkTargetEnv.ON_PREMISE && manifest != null ? manifest.getVersion() : null).build();
    }

    private ApplinkTargetEnv getTargetEnv(ApplicationLink applicationLink, ApplinkAppType appType, Manifest manifest) {
        if (CLOUD_ONLY_APPS.contains((Object)appType)) {
            return ApplinkTargetEnv.CLOUD;
        }
        if (ON_PREMISE_ONLY_APPS.contains((Object)appType)) {
            return ApplinkTargetEnv.ON_PREMISE;
        }
        Boolean isCloud = this.isCloud(manifest);
        if (isCloud == null) {
            log.warn("Could not determine target environment for: {}", (Object)applicationLink.getRpcUrl());
            return ApplinkTargetEnv.NO_CONNECTION;
        }
        return isCloud != false ? ApplinkTargetEnv.CLOUD : ApplinkTargetEnv.ON_PREMISE;
    }

    private Manifest getManifest(ApplicationLink applicationLink) {
        try {
            return this.manifestRetriever.getManifest(applicationLink.getRpcUrl());
        }
        catch (ManifestNotFoundException e) {
            log.warn("Could not fetch manifest for rpcUrl: {}", (Object)applicationLink.getRpcUrl(), (Object)e);
            return null;
        }
    }

    Boolean isCloud(Manifest manifest) {
        return Optional.ofNullable(manifest).map(Manifest::getVersion).map(String::trim).map(s -> s.split("\\.")).map(arr -> ((String[])arr).length == 0 ? null : arr[0]).map(Ints::tryParse).map(version -> version >= 1000).orElse(null);
    }

    @Generated
    public AssessmentApplinkService(ApplicationLinkService applicationLinkService, ManifestRetriever manifestRetriever) {
        this.applicationLinkService = applicationLinkService;
        this.manifestRetriever = manifestRetriever;
    }
}

