/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.request.v2.MigrationGroupV2Dto;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;

public class UsersMigrationShadowExecutor
extends ShadowMigrationExecutor {
    private static final Logger log = ContextLoggerFactory.getLogger(UsersMigrationShadowExecutor.class);
    private final ProgressTracker progressTracker;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;

    public UsersMigrationShadowExecutor(StepStore stepStore, ProgressTracker progressTracker, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(stepStore);
        this.progressTracker = progressTracker;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(StepType.USERS_MIGRATION.name()).prcTaskId(((TransferTask)prcTask.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        this.v4Logger.logInfo(log, logContext, "Performing shadow migration for users");
        Step originalStep = this.getOriginalStep(prcTask, StepType.USERS_MIGRATION);
        this.v4Logger.logInfo(log, logContext, String.format("Sending progress update for shadow users migration with originalStepId: %s", originalStep.getId()));
        this.sendProgressUpdate(prcTask);
        this.v4Logger.logInfo(log, logContext, "Sending completion status for shadow users migration");
        this.sendCompletionStatus(prcTask, originalStep);
        this.v4Logger.logInfo(log, logContext, "Shadow users migration completed successfully");
        return StepResult.succeeded("Exported & Uploaded Users And Groups for shadow migration");
    }

    private void sendProgressUpdate(PrcTask prcTask) {
        this.progressTracker.sendV4ProgressUpdates(Collections.emptyMap(), StepSubType.USERS_UPLOAD.getDetailedStatus(), prcTask, 100, "Successfully uploaded users and groups for shadow migration");
    }

    private void sendCompletionStatus(PrcTask prcTask, Step originalStep) {
        UsersMigrationExecutor.UsersMigrationExecutorJobMetadata jobMetadata = Jsons.readValue(originalStep.getExecutionState(), UsersMigrationExecutor.UsersMigrationExecutorJobMetadata.class);
        this.progressTracker.sendV4UserCompletionStatus(new UsersMigrationV2FilePayload(new ArrayList<MigrationUserDto>(jobMetadata.getRequestMetadata().getUserCount()), new ArrayList<MigrationGroupV2Dto>(jobMetadata.getRequestMetadata().getGroupCount()), Collections.emptyMap()), jobMetadata.getRequestMetadata().getFileId(), prcTask, "Successfully uploaded users and groups for shadow migration");
    }
}

