/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.AssessmentQueries;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.util.CsvBuilder;
import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.SeparateFileQuery;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;

public class GuardrailsAssessmentOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private static final Logger log = ContextLoggerFactory.getLogger(GuardrailsAssessmentOutputFileGenerator.class);
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final GuardrailsResponseStore guardrailsResponseStore;
    private final PluginTransactionTemplate ptx;
    private final AssessmentQueries assessmentQueries;
    private final OutputPathGenerator outputPathGenerator;
    private final InstanceAssessmentService instanceAssessmentService;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            List<GuardrailsResponse> guardrailsResponses;
            HashSet<Path> outputPaths = new HashSet<Path>();
            List<GuardrailsResponse> list = guardrailsResponses = example ? this.instanceAssessmentService.getExamples() : this.getAssessed();
            if (guardrailsResponses.isEmpty()) {
                log.error("No guardrails records found");
                throw new OutputFileGeneratorException("No guardrails records found");
            }
            Map<Boolean, List<GuardrailsResponse>> separateFileNecessity = this.splitBySeparateFileNecessity(guardrailsResponses);
            if (separateFileNecessity.containsKey(false)) {
                outputPaths.add(this.createGuardrailsCsv(separateFileNecessity.get(false), instanceMetadataDto, this.outputPathGenerator.csvFilePath(OutputFilenames.ENTITIES.getFilename(date))));
            }
            if (separateFileNecessity.containsKey(true)) {
                outputPaths.addAll(this.createSeparatePaths(separateFileNecessity.get(true), date, instanceMetadataDto));
            }
            return Collections.unmodifiableSet(outputPaths);
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    private List<GuardrailsResponse> getAssessed() {
        Optional guardrailsResponseGroup = this.ptx.read(this.guardrailsResponseGroupStore::findLast);
        log.info("Guardrails are present: {}", (Object)guardrailsResponseGroup.isPresent());
        if (guardrailsResponseGroup.isPresent()) {
            return this.ptx.read(() -> this.guardrailsResponseStore.getResponses(((GuardrailsResponseGroup)guardrailsResponseGroup.get()).getJobId()));
        }
        throw new IllegalStateException("Unable to generate file for download: guardrails response group not found");
    }

    private Set<Path> createSeparatePaths(List<GuardrailsResponse> guardrailsResponses, String date, InstanceMetadataDto instanceMetadataDto) throws IOException {
        HashSet<Path> separatePaths = new HashSet<Path>();
        for (GuardrailsResponse guardrailsResponse : guardrailsResponses) {
            QueryIds queryId = QueryIds.valueOf(guardrailsResponse.getQueryId());
            AssessmentQuery query = this.assessmentQueries.getQuery(queryId);
            SeparateFileQuery separateFileQuery = (SeparateFileQuery)query;
            separatePaths.add(separateFileQuery.createPath(date, instanceMetadataDto.getServerId(), instanceMetadataDto.getAssessmentDate(), instanceMetadataDto.getInstanceTimezone()));
        }
        return separatePaths;
    }

    private Map<Boolean, List<GuardrailsResponse>> splitBySeparateFileNecessity(List<GuardrailsResponse> guardrailsResponses) {
        return guardrailsResponses.stream().collect(Collectors.groupingBy(this::isSeparateFileQuery));
    }

    private boolean isSeparateFileQuery(GuardrailsResponse guardrailsResponse) {
        QueryIds queryId = QueryIds.valueOf(guardrailsResponse.getQueryId());
        return this.assessmentQueries.getQuery(queryId) instanceof SeparateFileQuery;
    }

    private Path createGuardrailsCsv(List<GuardrailsResponse> responses, InstanceMetadataDto instanceMetadataDto, Path csv) throws IOException {
        return new CsvBuilder<GuardrailsResponse>().addColumn("query_item", GuardrailsResponse::getQueryId).addColumn("query_result", GuardrailsResponse::getQueryResponse).addColumn("query_status", GuardrailsResponse::getQueryStatus).addColumn("product_name", instanceMetadataDto.getProduct().getName()).addColumn("product_version", instanceMetadataDto.getProduct().getVersion()).addColumn("sen", instanceMetadataDto.getSen()).addColumn("server_id", instanceMetadataDto.getServerId()).addColumn("instance_timezone", instanceMetadataDto.getInstanceTimezone()).addColumn("assessment_starting_date", instanceMetadataDto.getAssessmentDate()).addColumn("query_duration", GuardrailsResponse::getQueryDuration).addColumn("query_cpu_load", GuardrailsResponse::getQueryCpuLoad).build(csv, responses);
    }

    @Generated
    public GuardrailsAssessmentOutputFileGenerator(GuardrailsResponseGroupStore guardrailsResponseGroupStore, GuardrailsResponseStore guardrailsResponseStore, PluginTransactionTemplate ptx, AssessmentQueries assessmentQueries, OutputPathGenerator outputPathGenerator, InstanceAssessmentService instanceAssessmentService) {
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.guardrailsResponseStore = guardrailsResponseStore;
        this.ptx = ptx;
        this.assessmentQueries = assessmentQueries;
        this.outputPathGenerator = outputPathGenerator;
        this.instanceAssessmentService = instanceAssessmentService;
    }
}

