/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.group;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.check.PreflightLogContext;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictContext;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.user.GroupConflictsCheckRequest;
import com.atlassian.migration.agent.service.user.GroupsConflictCheckResponse;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class GroupNamesConflictChecker
implements Checker<GroupNamesConflictContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(GroupNamesConflictChecker.class);
    private static final String VIOLATIONS_KEY = "violations";
    private static final String CLOUD_ID = "cloudId";
    private static final String GROUP_COUNT = "groupCount";
    private final CloudSiteService cloudSiteService;
    private final ExecutorService executorService;
    private final RetryingUsersMigrationService usersMigrationService;
    private final PreflightLogger preflightLogger;

    GroupNamesConflictChecker(ExecutorService executorService, CloudSiteService cloudSiteService, RetryingUsersMigrationService usersMigrationService, PreflightLogger preflightLogger) {
        this.cloudSiteService = cloudSiteService;
        this.usersMigrationService = usersMigrationService;
        this.executorService = executorService;
        this.preflightLogger = preflightLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckResult check(GroupNamesConflictContext ctx) {
        String taskId;
        PreflightLogContext logContext = PreflightLogContext.builder().checkType(ctx.checkType).checkExecutionId(ctx.checkExecutionId).build();
        logContext.addAdditionalProperties(CLOUD_ID, ctx.cloudId, GROUP_COUNT, ctx.groups.size());
        if (CollectionUtils.isEmpty(ctx.groups)) {
            logContext.setIsSuccess(true);
            this.preflightLogger.logInfo(log, logContext, "No groups to check for conflicts");
            return new CheckResult(true);
        }
        this.preflightLogger.logInfo(log, logContext, String.format("Starting group names conflict check for %d groups", ctx.groups.size()));
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(ctx.cloudId);
        if (!cloudSite.isPresent()) {
            PreflightErrorCode errorCode = PreflightErrorCode.CLOUD_ERROR;
            logContext.setIsSuccess(false);
            this.preflightLogger.logError(log, logContext, String.format("Cloud Site Not Found: %s", errorCode.getMessage()), null);
            return Checker.buildCheckResultWithExecutionError((int)errorCode.getCode());
        }
        String containerToken = cloudSite.get().getContainerToken();
        Future<GroupsConflictCheckResponse> future = null;
        try {
            taskId = this.usersMigrationService.startGroupConflictsCheck(containerToken, new GroupConflictsCheckRequest(ctx.groups));
        }
        catch (Exception e) {
            PreflightErrorCode errorCode = PreflightErrorCode.GROUP_CONFLICT_CHECK_ERROR;
            logContext.setIsSuccess(false);
            this.preflightLogger.logError(log, logContext, "Failed to start group conflicts check", e);
            return Checker.buildCheckResultWithExecutionError((int)errorCode.getCode());
        }
        try {
            future = this.executorService.submit(() -> {
                GroupsConflictCheckResponse response;
                while (!(response = this.usersMigrationService.getGroupConflictsCheckStatus(containerToken, taskId)).isComplete()) {
                    try {
                        this.doSleep(2500);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return response;
            });
            GroupsConflictCheckResponse checkResponse = future.get(5L, TimeUnit.MINUTES);
            List conflictingGroups = checkResponse.getConflictingGroups().stream().sorted().collect(Collectors.toList());
            boolean success = checkResponse.isSuccessful();
            logContext.setIsSuccess(success);
            logContext.addAdditionalProperties(VIOLATIONS_KEY, conflictingGroups);
            this.preflightLogger.logInfo(log, logContext, success && conflictingGroups.isEmpty() ? "No conflicting groups found" : String.format("Found %d conflicting groups", conflictingGroups.size()));
            CheckResult checkResult = new CheckResult(success, Collections.singletonMap(VIOLATIONS_KEY, conflictingGroups));
            return checkResult;
        }
        catch (Exception e) {
            logContext.setIsSuccess(false);
            this.preflightLogger.logError(log, logContext, "Error occurred during group names conflict check", e);
            CheckResult checkResult = Checker.buildCheckResultWithExecutionError((int)PreflightErrorCode.GENERIC_ERROR.getCode());
            return checkResult;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    static List<String> retrieveDuplicateGroupNames(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS_KEY, Collections.emptyList());
    }

    @VisibleForTesting
    void doSleep(int milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }
}

