/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.migration.agent.service.BaseLogContext;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.slf4j.Logger;

public class BaseLogger<T extends BaseLogContext> {
    public void logInfo(Logger logger, T context, String message) {
        this.log(context, logger, Level.INFO, message, null);
    }

    public void logDebug(Logger logger, T context, String message) {
        this.log(context, logger, Level.DEBUG, message, null);
    }

    public void logError(Logger logger, T context, String message) {
        this.log(context, logger, Level.ERROR, message, null);
    }

    public void logWarn(Logger logger, T context, String message) {
        this.log(context, logger, Level.WARN, message, null);
    }

    public void logError(Logger logger, T context, String message, Throwable throwable) {
        this.log(context, logger, Level.ERROR, message, throwable);
    }

    public void logDebug(Logger logger, T context, String message, Throwable throwable) {
        this.log(context, logger, Level.DEBUG, message, throwable);
    }

    public void logWarn(Logger logger, T context, String message, Throwable throwable) {
        this.log(context, logger, Level.WARN, message, throwable);
    }

    protected void log(T context, Logger logger, Level level, String message, Throwable throwable) {
        Map<String, Object> logCtx = ((BaseLogContext)context).getLogContext();
        try {
            String levelString;
            Map<String, Object> filteredLogCtx = logCtx.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!filteredLogCtx.isEmpty()) {
                message = message + " | Context: " + filteredLogCtx.toString();
            }
            switch (levelString = level.toString().toLowerCase()) {
                case "debug": {
                    logger.debug(message);
                    break;
                }
                case "warn": {
                    if (throwable != null) {
                        logger.warn(message, throwable);
                        break;
                    }
                    logger.warn(message);
                    break;
                }
                case "error": {
                    if (throwable != null) {
                        logger.error(message, throwable);
                        break;
                    }
                    logger.error(message);
                    break;
                }
                default: {
                    logger.info(message);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

