/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service;

import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import java.util.function.Supplier;

public class SimpleTypeSetting {
    private static final String PLUGIN_KEY = "com.atlassian.migration.agent";
    private final Supplier<PluginSettings> pluginSettingsSupplier;
    private final MigrationSettingsType migrationSettingsType;
    private final String settingsTypeKey;

    public SimpleTypeSetting(Supplier<PluginSettings> pluginSettingsSupplier, MigrationSettingsType migrationSettingsType) {
        this.pluginSettingsSupplier = pluginSettingsSupplier;
        this.migrationSettingsType = migrationSettingsType;
        this.settingsTypeKey = String.format("%s:%s", new Object[]{PLUGIN_KEY, migrationSettingsType});
    }

    public MigrationSettingsType getMigrationSettingsType() {
        return this.migrationSettingsType;
    }

    public String getSettingsAsString() {
        Object content = this.pluginSettingsSupplier.get().get(this.settingsTypeKey);
        if (content != null) {
            return (String)content;
        }
        return "";
    }

    public boolean putChangedSettings(Object settingsTypeValue) {
        if (this.settingsUnchanged(settingsTypeValue)) {
            return false;
        }
        this.pluginSettingsSupplier.get().put(this.settingsTypeKey, (Object)Jsons.valueAsString(settingsTypeValue));
        return true;
    }

    private boolean settingsUnchanged(Object settingsTypeValue) {
        return this.pluginSettingsSupplier.get().equals(settingsTypeValue);
    }
}

