/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="featureflag")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FeatureFlagResource {
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final FeatureFlagClient featureFlagClient;

    @Inject
    public FeatureFlagResource(MigrationDarkFeaturesManager migrationDarkFeaturesManager, FeatureFlagClient featureFlagClient) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.featureFlagClient = featureFlagClient;
    }

    @GET
    @Path(value="/all")
    public Response getAllEnabledFeatureFlags() {
        return Response.ok(this.migrationDarkFeaturesManager.getAllEnabledFeatures()).build();
    }

    @GET
    @Path(value="/all/{planId}")
    public Response getAllEnabledFeatureFlagsForPlan(@PathParam(value="planId") String planId) {
        return Response.ok(this.migrationDarkFeaturesManager.getAllEnabledFeatures()).build();
    }

    @GET
    @Path(value="/launchdarkly/all")
    public Response getAllLaunchDarklyFeatureFlags() {
        return Response.ok(new HashSet<String>(this.featureFlagClient.getAllEnabledFeatureFlags())).build();
    }

    @GET
    @Path(value="/statsig/configs")
    public Response getDynamicConfig() {
        return Response.ok(this.featureFlagClient.getAllConfigsFromStatsig()).build();
    }

    @GET
    @Path(value="/statsig/configs/{configName}")
    public Response getDynamicConfigByHash(@PathParam(value="configName") String configName) {
        Object configValue = this.featureFlagClient.getConfigValueByName(configName);
        if (configValue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Value not found for provided config").build();
        }
        return Response.ok((Object)configValue).build();
    }
}

