/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUploadExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class SpaceUploadProcessor
extends AbstractProcessor<SpaceUploadTransferTask> {
    private final SpaceUploadExecutor spaceUploadExecutor;
    private final Step prcStep;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUploadProcessor.class);

    public SpaceUploadProcessor(PrcTask<SpaceUploadTransferTask> prcTask, Step prcStep, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, SpaceUploadExecutor spaceUploadExecutor, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, migrationLogService);
        this.spaceUploadExecutor = spaceUploadExecutor;
        this.prcStep = prcStep;
    }

    @VisibleForTesting
    SpaceUploadProcessor(PrcTask<SpaceUploadTransferTask> prcTask, SpaceUploadExecutor spaceUploadExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, Step prcStep, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, heartbeatScheduler, migrationLogService);
        this.spaceUploadExecutor = spaceUploadExecutor;
        this.prcStep = prcStep;
    }

    @Override
    protected Pair<Step, StepResult> process() {
        log.info("Processing V4 space data upload. PrcStep id: {}", (Object)this.prcStep.getId());
        this.setProgressStartTime(this.prcStep, StepType.DATA_UPLOAD);
        StepResult result = this.spaceUploadExecutor.runV4Step(this.prcStep.getId(), this.prcTask);
        log.info("Finished processing V4 space data upload. PrcStep id: {}", (Object)this.prcStep.getId());
        return Pair.of((Object)this.prcStep, (Object)result);
    }
}

