/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.store.guardrails.GuardrailsFeatureFlagHelperService;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.GuardrailsQueries;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;

public class PageDepthQuery
extends ListQuery {
    private static final int LIMIT = 100;
    private static final int PAGE_DEPTH_CUTOFF = 200;
    private final DbType dbType;
    private final GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService;

    public PageDepthQuery(EntityManagerTemplate tmpl, DbType dbType, GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService) {
        super(QueryIds.PAGE_TREE_DEPTH, tmpl, GuardrailsQueries.PAGE_DEPTH_QUERY.query(dbType), true, guardrailsFeatureFlagHelperService.createQueryBuilderRecordsLimit(), PageDepthQuery.example("space_id", "max_depth").addRow(100L, 15).addRow(115L, 8));
        this.guardrailsFeatureFlagHelperService = guardrailsFeatureFlagHelperService;
        this.dbType = dbType;
    }

    @Override
    public ListResult execute() {
        if (DbType.MYSQL == this.dbType) {
            if (this.guardrailsFeatureFlagHelperService.recordsLimit() != null) {
                return new ListResult(this.findPageDepthPerSpace(), 100);
            }
            return new ListResult(this.findPageDepthPerSpace());
        }
        return super.execute();
    }

    @Override
    public Duration getTimeout() {
        return LONG_QUERY_TIMEOUT;
    }

    private List<Tuple> findPageDepthPerSpace() {
        List<Tuple> result = this.createNativeQuery(Tuple.class, "select CONTENTID FROM CONTENT WHERE PARENTID is NULL and CONTENT_STATUS = 'current' and PREVVER is NULL and CONTENTTYPE = 'PAGE';").list();
        HashMap<Number, Integer> maxSpaceDepth = new HashMap<Number, Integer>();
        for (int depth = 1; depth <= 200 && !result.isEmpty(); ++depth) {
            result = this.createNativeQuery(Tuple.class, GuardrailsQueries.pageDepthChildPageQuery(result)).list();
            for (Tuple t : result) {
                maxSpaceDepth.put((Number)t.get(1, Number.class), depth);
            }
        }
        Stream sortedStream = maxSpaceDepth.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed());
        if (this.guardrailsFeatureFlagHelperService.recordsLimit() != null) {
            sortedStream = sortedStream.limit(100L);
        }
        return sortedStream.map(e -> GuardrailsUtil.getTuple((Map<String, Object>)ImmutableMap.of((Object)"space_id", e.getKey(), (Object)"max_depth", e.getValue()))).collect(Collectors.toList());
    }
}

