/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.entity.InstanceAnalysisControl;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlService;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlTypes;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.service.guardrails.usage.AccessLogProcessingJobRunner;
import com.atlassian.migration.agent.store.guardrails.AssessmentDuration;
import com.atlassian.migration.agent.store.guardrails.AssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAnalysisControlStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AssessmentJobProgressService {
    private static final Logger log = ContextLoggerFactory.getLogger(AssessmentJobProgressService.class);
    private static final String COLLECTION_BROWSER_METRICS = "Collecting browser metrics";
    private final InstanceAnalysisControlStore instanceAnalysisControlStore;
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    private static final String SERVER_NODE = "serverNode";
    private static final int TIME_IN_MINUTES = 60;
    private final InstanceAssessmentService instanceAssessmentService;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final AccessLogProcessingJobRunner accessLogProcessingJobRunner;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;
    private final PluginTransactionTemplate ptx;

    public AssessmentJobProgressService(InstanceAnalysisControlStore instanceAnalysisControlStore, InstanceAnalysisControlService instanceAnalysisControlService, GuardrailsResponseGroupStore guardrailsResponseGroupStore, InstanceAssessmentService instanceAssessmentService, AccessLogProcessingJobRunner accessLogProcessingJobRunner, InstanceAssessmentConfigClient instanceAssessmentConfigClient, PluginTransactionTemplate ptx) {
        this.instanceAnalysisControlStore = instanceAnalysisControlStore;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.instanceAssessmentService = instanceAssessmentService;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.accessLogProcessingJobRunner = accessLogProcessingJobRunner;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
        this.ptx = ptx;
    }

    public AssessmentStatus processJobProgress() {
        AssessmentStatus assessmentStatus = this.getAssessmentStatus();
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.COMPLETE) {
            return AssessmentStatus.completedAssessment(assessmentStatus.getFinishDate());
        }
        return assessmentStatus;
    }

    @NotNull
    private AssessmentStatus getAssessmentStatus() {
        return this.ptx.read(this.guardrailsResponseGroupStore::findLast).map(guardrailsResponseGroup -> {
            Optional<InstanceAnalysisControl> instanceAnalysisControl;
            InstanceAssessmentConfig config = InstanceAssessmentConfig.deserialize(guardrailsResponseGroup.getConfigJson()).orElse(this.instanceAssessmentConfigClient.getDefaultConfig());
            if (config.isLongRunning() && (instanceAnalysisControl = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent()) {
                return this.getBrowserMetricsProgress(instanceAnalysisControl.get());
            }
            return this.getGrQueriesProgress((GuardrailsResponseGroup)guardrailsResponseGroup);
        }).orElseGet(AssessmentStatus::notStartedAssessment);
    }

    private AssessmentStatus getGrQueriesProgress(GuardrailsResponseGroup guardrailsResponseGroup) {
        String jobId = guardrailsResponseGroup.getJobId();
        try {
            Set<JobDetails> activeJobsDetails = this.instanceAssessmentService.getActiveJobs();
            Set activeJobs = activeJobsDetails.stream().map(JobDetails::getJobId).map(Object::toString).collect(Collectors.toSet());
            log.info("Current jobId is:{} and number of running jobs are:{}", (Object)jobId, (Object)activeJobs.size());
            if (activeJobs.contains(jobId)) {
                Pair<Duration, Long> progress = this.instanceAssessmentService.getJobProgress(jobId);
                return AssessmentStatus.inProgressAssessment(((Duration)progress.getLeft()).toMillis(), (Long)progress.getRight(), "Collecting guardrails, " + progress.getRight() + "% COMPLETE");
            }
            if (guardrailsResponseGroup.isCanceled()) {
                return AssessmentStatus.cancelAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
            }
            log.info("Job completed for jobId:{}", (Object)jobId);
            return AssessmentStatus.completedAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
        }
        catch (Exception e) {
            log.error("Failed to get progress for jobId:{}", (Object)jobId, (Object)e);
            return AssessmentStatus.failedAssessment();
        }
    }

    private AssessmentStatus getBrowserMetricsProgress(InstanceAnalysisControl instanceAnalysisControl) {
        if (this.instanceAnalysisControlStore.isFinished(instanceAnalysisControl)) {
            if (!this.accessLogProcessingJobRunner.isFinished()) {
                return AssessmentStatus.inProgressAssessment(1000L, 99L, COLLECTION_BROWSER_METRICS);
            }
            Long endTimestamp = instanceAnalysisControl.getEndTimestamp();
            Timestamp tms = new Timestamp(endTimestamp);
            Date completedDate = new Date(tms.getTime());
            if (instanceAnalysisControl.isCanceled()) {
                return AssessmentStatus.cancelAssessment(completedDate.toInstant());
            }
            return AssessmentStatus.completedAssessment(completedDate.toInstant());
        }
        Duration remainingDuration = this.instanceAnalysisControlService.calculateRemainingDuration(instanceAnalysisControl);
        if (remainingDuration.isZero()) {
            this.finishAssessmentCollection();
        }
        long percentage = 100L - remainingDuration.toMillis() * 100L / this.instanceAnalysisControlService.assessmentDuration().toMillis();
        return AssessmentStatus.inProgressAssessment(remainingDuration.toMillis(), percentage, COLLECTION_BROWSER_METRICS);
    }

    private void finishAssessmentCollection() {
        log.info("Stopping Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.finishAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentStatus scheduleInstanceAssessment(boolean cloudTriggered, @Nullable InstanceAssessmentConfig config) throws SchedulerServiceException {
        InstanceAssessmentConfig resolvedConfig = this.instanceAssessmentConfigClient.resolveConfig(config);
        log.info("Will use following config for Assessment: {}", (Object)resolvedConfig);
        this.accessLogProcessingJobRunner.startAssessment(resolvedConfig);
        Optional<InstanceAnalysisControl> currentInstanceAnalysis = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name());
        if (currentInstanceAnalysis.isPresent() && !this.instanceAnalysisControlStore.isFinished(currentInstanceAnalysis.get())) {
            AssessmentStatus status = this.processJobProgress();
            return AssessmentStatus.inProgressAssessment(status.getRemainingDuration(), status.getPercentage(), status.getDescription());
        }
        Set<JobDetails> activeJobs = this.instanceAssessmentService.getActiveJobs();
        if (!activeJobs.isEmpty()) {
            JobDetails job = activeJobs.iterator().next();
            String jobId = job.getJobId().toString();
            Map map = job.getParameters();
            String nodeId = (String)map.get(SERVER_NODE);
            log.info("Job already running for nodeId: {} and jobId:{}", (Object)nodeId, (Object)jobId);
            AssessmentStatus status = this.processJobProgress();
            return AssessmentStatus.inProgressAssessment(status.getRemainingDuration(), status.getPercentage(), status.getDescription());
        }
        log.info("There are no active jobs");
        this.instanceAnalysisControlService.startAssessmentCollection(cloudTriggered, resolvedConfig);
        this.instanceAssessmentService.scheduleJob(cloudTriggered, resolvedConfig);
        return AssessmentStatus.newAssessment();
    }

    public AssessmentStatus cancelAssessmentCollection() {
        InstanceAssessmentStatus status = this.processJobProgress().getStatus();
        if (status.equals((Object)InstanceAssessmentStatus.IN_PROGRESS)) {
            this.cancelGuardrailsCollection();
            this.cancelBrowserMetricsCollection();
            this.instanceAnalysisControlService.publishCancelEvent();
            return AssessmentStatus.cancelAssessment(Instant.now());
        }
        return AssessmentStatus.notStartedAssessment();
    }

    private void cancelGuardrailsCollection() {
        this.instanceAssessmentService.cancelAssessmentCollection();
    }

    private void cancelBrowserMetricsCollection() {
        log.info("Cancelling Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.cancelAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentDuration getTotalJobDuration(InstanceAssessmentConfig config) {
        InstanceAssessmentConfig resolvedConfig = this.instanceAssessmentConfigClient.resolveConfig(config);
        if (resolvedConfig.isLongRunning()) {
            return new AssessmentDuration(this.instanceAnalysisControlService.assessmentDuration().toMillis());
        }
        return new AssessmentDuration(this.instanceAssessmentService.getTotalAssessmentApproxDuration(resolvedConfig).toMillis());
    }
}

