/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.ExecutionErrorCodes;
import com.atlassian.migration.agent.entity.CheckExecutionStatus;
import com.atlassian.migration.agent.entity.CheckResultEntity;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.exception.FailedToRetrieveViolationsException;
import com.atlassian.migration.agent.store.impl.CheckResultStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class CheckResultsService {
    public static final String DETAILS_PATH_KEY = "path";
    public static final String VIOLATIONS_COUNT_KEY = "violationsCount";
    public static final String ERROR_MESSAGE_KEY = "errorMessage";
    public static final String ERROR_CODE = "errorCode";
    public static final String CLOUD_ID = "cloudId";
    public static final String SPACE_KEYS = "spaceKeys";
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResultsService.class);
    private final CheckResultStore checkResultStore;
    private final CheckResultFileManager checkResultFileManager;
    private final PluginTransactionTemplate ptx;

    public CheckResultsService(CheckResultStore checkResultStore, CheckResultFileManager checkResultFileManager, PluginTransactionTemplate ptx) {
        this.checkResultStore = checkResultStore;
        this.checkResultFileManager = checkResultFileManager;
        this.ptx = ptx;
    }

    public Optional<CheckResultEntity> getByExecutionIdAndCheckType(String executionId, CheckType checkType) {
        return this.ptx.read(() -> this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType));
    }

    public List<CheckResultEntity> getByExecutionId(String executionId) {
        return this.ptx.read(() -> this.checkResultStore.getByExecutionId(executionId));
    }

    public List<CheckResultEntity> getByUniqueId(String uniqueId) {
        return this.ptx.read(() -> this.checkResultStore.getByUniqueId(uniqueId));
    }

    public CheckResultEntity getOrCreate(String executionId, CheckType checkType) {
        return this.ptx.write(() -> this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType).orElseGet(() -> {
            CheckResultEntity entity = new CheckResultEntity(executionId, checkType.value());
            this.checkResultStore.create(entity);
            return entity;
        }));
    }

    public void update(CheckResultEntity entity) {
        this.ptx.write(() -> this.checkResultStore.update(entity));
    }

    public void saveCheckResult(String executionId, CheckType checkType, CheckResult checkResult) {
        this.ptx.write(() -> {
            Optional<CheckResultEntity> result = this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType);
            CheckResultEntity entity = result.orElseThrow(() -> new IllegalArgumentException(String.format("Failed to find checkResult for executionId: %s and checkType: %s", executionId, checkType.value())));
            entity.setStatus(checkResult.success ? CheckExecutionStatus.SUCCESS : CheckExecutionStatus.ERROR);
            String filename = this.createFilename(executionId, checkType);
            entity.setDetails(filename);
            try {
                log.info("save to file, filename: {}, checkResult: {}", (Object)filename, (Object)checkResult);
                this.checkResultFileManager.saveToFile(filename, checkResult);
            }
            catch (RuntimeException ex) {
                log.error(String.format("Failed to save check result details to file for executionId = %s and checkType = %s", executionId, checkResult), (Throwable)ex);
                entity.setStatus(CheckExecutionStatus.ERROR);
            }
            entity.setLastExecutionTime(Instant.now());
            this.checkResultStore.update(entity);
        });
    }

    public Optional<CheckResult> getCheckResult(CheckResultEntity entity) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getDetails())) {
            try {
                String details = entity.getDetails();
                log.debug("getCheckResult details: {}", (Object)details);
                return Optional.of(this.checkResultFileManager.readFromFile(details));
            }
            catch (RuntimeException e) {
                log.error("Couldn't retrieve check result", (Throwable)e);
                if (this.isIOExceptionCause(e)) {
                    log.error("IOException detected while reading from file, marking preflight as ERRORED for entity: {} with checkType: {}", (Object)entity.getId(), (Object)entity.getCheckType());
                    this.ptx.write(() -> {
                        entity.setStatus(CheckExecutionStatus.ERROR);
                        this.checkResultStore.update(entity);
                        return null;
                    });
                }
                return Optional.of(Checker.buildCheckResultWithExecutionError((int)ExecutionErrorCodes.GENERIC.getErrorCode()));
            }
        }
        return Optional.empty();
    }

    private boolean isIOExceptionCause(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (!(current instanceof IOException)) continue;
            return true;
        }
        return false;
    }

    private String createFilename(String executionId, CheckType checkType) {
        log.info("create fileName using executionId: {}, checkType: {}", (Object)executionId, (Object)checkType);
        return executionId + "-" + checkType.value() + ".ser";
    }

    public int deleteCheckResultsByExecutionId(String executionId) {
        log.info("Deleting check results by executionId: {}", (Object)executionId);
        return this.ptx.write(() -> this.checkResultStore.deleteCheckResultsByExecutionId(executionId));
    }

    public void bindCheckIdToPlanId(String checkExecutionId, String planId) {
        log.info("Binding checkExecutionId: {} to planId: {}", (Object)checkExecutionId, (Object)planId);
        this.ptx.write(() -> this.checkResultStore.updateExecutionId(checkExecutionId, planId));
    }

    public <T> List<T> retrieveStoredViolations(CheckResult checkResult, TypeReference<List<T>> typeReference) {
        Map details = checkResult.details;
        try {
            if (MapUtils.isEmpty((Map)details) || Integer.parseInt(((Object)details.getOrDefault(VIOLATIONS_COUNT_KEY, 0)).toString()) == 0) {
                return Collections.emptyList();
            }
            return this.checkResultFileManager.readFromJsonFile((String)details.get(DETAILS_PATH_KEY), typeReference);
        }
        catch (Exception e) {
            log.error(String.format("Error retrieving the list of violations from details: %s, Type: %s", details, typeReference.getType()), (Throwable)e);
            throw new FailedToRetrieveViolationsException(e.getMessage(), e);
        }
    }

    public void cleanStaleChecks() {
        this.ptx.write(() -> this.checkResultStore.batchUpdateStatus(CheckExecutionStatus.RUNNING, Instant.now().minus(Duration.ofHours(24L)), CheckExecutionStatus.ERROR));
    }

    public boolean hasRunningPreflights() {
        List<CheckResultEntity> runningPreflights = this.checkResultStore.getRunningChecks();
        return !runningPreflights.isEmpty();
    }

    public int updateStatus(String executionId, CheckExecutionStatus newStatus) {
        return this.ptx.write(() -> this.checkResultStore.updateStatus(executionId, newStatus));
    }
}

