/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class CUDCAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public CUDCAnalyticsEventBuilder(SENSupplier senSupplier, PluginVersionManager pluginVersionManager, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(senSupplier, Instant::now, pluginVersionManager, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    CUDCAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, PluginVersionManager pluginVersionManager, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildUserBaseScanStartedEvent(String scanId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"scanId", (Object)scanId);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("started")).sen(this.senSupplier.get())).source("user-data-compatibility-plugin-2")).actionSubject("userBaseScan")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserBaseScanErrorEvent(String reason, String cloudId, String scanId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"scanId", (Object)scanId);
        attributes.put((Object)"reason", (Object)reason);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("user-data-compatibility-plugin-2")).cloudId(cloudId)).actionSubject("userBaseScan")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserBaseScanFinishedEvent(String scanId, int totalUsersCount, int invalidUsersCount, int duplicateUsersCount, long timeToComplete) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"scanId", (Object)scanId);
        attributes.put((Object)"status", (Object)"success");
        attributes.put((Object)"totalUsersCount", (Object)totalUsersCount);
        attributes.put((Object)"invalidUsersCount", (Object)invalidUsersCount);
        attributes.put((Object)"duplicateUsersCount", (Object)duplicateUsersCount);
        attributes.put((Object)"timeToComplete", (Object)timeToComplete);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).source("user-data-compatibility-plugin-2")).actionSubject("userBaseScan")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildNewEmailSuggestingFinishedEvent(String cloudId, int emailsFetchedCount, int uniqueDomainsFetchedCount, int blockedDomainsCount, long blockedDomainsLookupTime, long executionTime, String emailsSource) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"status", (Object)"success");
        attributes.put((Object)"emailsFetchedCount", (Object)emailsFetchedCount);
        attributes.put((Object)"uniqueDomainsFetchedCount", (Object)uniqueDomainsFetchedCount);
        attributes.put((Object)"blockedDomainsCount", (Object)blockedDomainsCount);
        attributes.put((Object)"blockedDomainsLookupTime", (Object)blockedDomainsLookupTime);
        attributes.put((Object)"executionTime", (Object)executionTime);
        attributes.put((Object)"emailsSource", (Object)emailsSource);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).source("user-data-compatibility-plugin-2")).cloudId(cloudId)).actionSubject("newEmailSuggesting")).action("finished")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainCountsFetchedEvent(long timeTaken, long userCount, int domainCount, boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"totalUserDomainCount", (Object)domainCount);
        attributes.put((Object)"totalUserCount", (Object)userCount);
        attributes.put((Object)"timeTaken", (Object)Long.toString(timeTaken));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("fetched")).sen(this.senSupplier.get())).actionSubject("userDomainCounts")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRuleUpdatedEvent(DomainRuleBehaviour rule, boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"rule", (Object)String.valueOf((Object)rule));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRuleDeletedEvent(boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deleted")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAllUserDomainRuleDeletedEvent(boolean success, int count) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"count", (Object)count);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deleted-all")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRulesDeletedEvent(boolean success, int count) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"count", (Object)count);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deleted")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRulesCreatedEvent(int numRulesCreated, boolean success) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"numRulesCreated", (Object)numRulesCreated);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("batchUserDomainRulesCreated")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUserDomainRulesUpdatedFromCloudEvent(int numOfRulesUpdated, boolean success, Optional<Exception> optionalException) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"numOfRulesUpdated", (Object)numOfRulesUpdated);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("userDomainRulesUpdatedFromCloud")).sen(this.senSupplier.get())).actionSubject("userDomainRule")).withAttributes((Map)attributes.build());
        optionalException.ifPresent(e -> builder.addAttribute("errorCode", (Object)e.getClass().getCanonicalName()));
        optionalException.ifPresent(e -> builder.addAttribute("reason", (Object)e.getMessage()));
        return builder.build();
    }
}

