/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport.processor;

import com.atlassian.migration.agent.newexport.processor.AbstractBodyContentTransformer;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2ToForgeMacroBodyContentTransformerImpl
extends AbstractBodyContentTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(P2ToForgeMacroBodyContentTransformerImpl.class);
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("(<ac:structured-macro[^>]*?\\s+ac:name\\s*=\\s*['\"])([^'\"]+)(['\"])");
    private final Map<String, String> macroNameMappings;

    public P2ToForgeMacroBodyContentTransformerImpl(Map<String, String> macroNameMappings) {
        if (macroNameMappings == null) {
            throw new IllegalArgumentException("Macro name mappings cannot be null");
        }
        this.macroNameMappings = Collections.unmodifiableMap(macroNameMappings);
    }

    @Override
    public String transform(String entry) {
        if (this.macroNameMappings.isEmpty()) {
            return entry;
        }
        if (entry == null || entry.isEmpty()) {
            return entry;
        }
        if (!this.containsStructuredMacro(entry)) {
            return entry;
        }
        return this.replaceMacroNames(entry);
    }

    private boolean containsStructuredMacro(String entry) {
        return entry.contains("ac:structured-macro") && MACRO_NAME_PATTERN.matcher(entry).find();
    }

    private String replaceMacroNames(String entry) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = MACRO_NAME_PATTERN.matcher(entry);
        while (matcher.find()) {
            String currentMacroName = matcher.group(2);
            String newMacroName = this.macroNameMappings.get(currentMacroName);
            if (newMacroName == null) continue;
            String replacement = matcher.group(1) + newMacroName + matcher.group(3);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

