/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.recipe;

import com.atlassian.migration.agent.v4.recipe.RecipeContext;
import com.atlassian.migration.agent.v4.recipe.RecipeMigrationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecipeExecutionRequest {
    private String id;
    private String name;
    private String executionId;
    private RecipeContext context;
    private CommonContext commonContext;
    private List<String> tags;
    private RecipeCommand command;
    private RecipeAction action;
    private int version = 8;
    private static final String MIGRATION = "migration";
    private static final String CONF_SERVER_TO_CLOUD = "confluence-server-to-cloud";

    public RecipeExecutionRequest(String name, RecipeContext context, CommonContext commonContext, RecipeCommand command) {
        this.id = UUID.randomUUID().toString();
        this.executionId = commonContext.migration.getId();
        this.name = name;
        this.context = context;
        this.commonContext = commonContext;
        this.tags = Arrays.asList(MIGRATION, CONF_SERVER_TO_CLOUD);
        this.command = command;
    }

    public RecipeExecutionRequest(String name, String migrationId, RecipeAction action) {
        this.executionId = migrationId;
        this.name = name;
        this.action = action;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public RecipeContext getContext() {
        return this.context;
    }

    @Generated
    public CommonContext getCommonContext() {
        return this.commonContext;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public RecipeCommand getCommand() {
        return this.command;
    }

    @Generated
    public RecipeAction getAction() {
        return this.action;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setContext(RecipeContext context) {
        this.context = context;
    }

    @Generated
    public void setCommonContext(CommonContext commonContext) {
        this.commonContext = commonContext;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setCommand(RecipeCommand command) {
        this.command = command;
    }

    @Generated
    public void setAction(RecipeAction action) {
        this.action = action;
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeExecutionRequest)) {
            return false;
        }
        RecipeExecutionRequest other = (RecipeExecutionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        RecipeContext this$context = this.getContext();
        RecipeContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        CommonContext this$commonContext = this.getCommonContext();
        CommonContext other$commonContext = other.getCommonContext();
        if (this$commonContext == null ? other$commonContext != null : !this$commonContext.equals(other$commonContext)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        RecipeCommand this$command = this.getCommand();
        RecipeCommand other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)((Object)this$command)).equals((Object)other$command)) {
            return false;
        }
        RecipeAction this$action = this.getAction();
        RecipeAction other$action = other.getAction();
        return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecipeExecutionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        RecipeContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        CommonContext $commonContext = this.getCommonContext();
        result = result * 59 + ($commonContext == null ? 43 : $commonContext.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        RecipeCommand $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)((Object)$command)).hashCode());
        RecipeAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RecipeExecutionRequest(id=" + this.getId() + ", name=" + this.getName() + ", executionId=" + this.getExecutionId() + ", context=" + this.getContext() + ", commonContext=" + this.getCommonContext() + ", tags=" + this.getTags() + ", command=" + (Object)((Object)this.getCommand()) + ", action=" + (Object)((Object)this.getAction()) + ", version=" + this.getVersion() + ")";
    }

    public static class CommonContext {
        private RecipeMigrationDetails migration;

        public CommonContext(RecipeMigrationDetails migration) {
            this.migration = migration;
        }

        public RecipeMigrationDetails getMigration() {
            return this.migration;
        }

        public void setMigration(RecipeMigrationDetails migration) {
            this.migration = migration;
        }
    }

    public static enum RecipeCommand {
        START,
        STOP;

    }

    public static enum RecipeAction {
        TERMINATE;

    }
}

