/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import lombok.Generated;

public enum TransferResultStatus {
    READY(ExecutionStatus.CREATED),
    IN_PROGRESS(ExecutionStatus.RUNNING),
    CANCELLING(ExecutionStatus.STOPPING),
    SUCCESS(ExecutionStatus.DONE),
    FAILED(ExecutionStatus.FAILED),
    INCOMPLETE(ExecutionStatus.FAILED),
    SKIPPED(ExecutionStatus.DONE),
    TIMED_OUT(ExecutionStatus.FAILED),
    CANCELLED(ExecutionStatus.STOPPED);

    private ExecutionStatus executionStatus;
    private static final Set<TransferResultStatus> UNSUCCESSFUL_STATUSES;
    private static final Set<TransferResultStatus> TRANSFER_RESULT_STATUSES_TO_ADAPT_WITH_CONTAINER_STATUS;

    private TransferResultStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public TransferResultStatus adaptStatus(AbstractContainer.ContainerStatus containerStatus) {
        if (containerStatus.isUnsuccessful() && TRANSFER_RESULT_STATUSES_TO_ADAPT_WITH_CONTAINER_STATUS.contains((Object)this)) {
            switch (containerStatus) {
                case TIMED_OUT: {
                    return TIMED_OUT;
                }
                case CANCELLED: {
                    return CANCELLED;
                }
            }
            return FAILED;
        }
        return this;
    }

    public boolean isCompleted() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isUnsuccessful() {
        switch (this.ordinal()) {
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Generated
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    static {
        UNSUCCESSFUL_STATUSES = ImmutableSet.of((Object)((Object)FAILED), (Object)((Object)INCOMPLETE), (Object)((Object)TIMED_OUT), (Object)((Object)CANCELLED));
        TRANSFER_RESULT_STATUSES_TO_ADAPT_WITH_CONTAINER_STATUS = ImmutableSet.of((Object)((Object)READY), (Object)((Object)IN_PROGRESS));
    }
}

