/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.dto.util.ConcurrencyOverrideGroup;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.SimpleTypeSetting;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencySettingsServiceManual {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcurrencySettingsServiceManual.class);
    private static final TypeReference<HashMap<ConcurrencySettingsEnum, Integer>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<ConcurrencySettingsEnum, Integer>>(){};
    private final SimpleTypeSetting simpleTypeSetting;
    private MigrationDarkFeaturesManager darkFeaturesManager;

    public ConcurrencySettingsServiceManual(Supplier<PluginSettings> pluginSettingsSupplier, MigrationDarkFeaturesManager darkFeaturesManager) {
        this.simpleTypeSetting = new SimpleTypeSetting(pluginSettingsSupplier, MigrationSettingsType.CONCURRENCY);
        this.darkFeaturesManager = darkFeaturesManager;
        this.updateDefaultSettings();
    }

    private void updateDefaultSettings() {
        Map<ConcurrencySettingsEnum, Integer> currentCurrencySettings = this.getDefaultPluginSettings();
        currentCurrencySettings.putAll(this.getSettings());
        this.putSettings(currentCurrencySettings);
    }

    public Map<ConcurrencySettingsEnum, Integer> getSettings() {
        return (Map)this.getSettingsObject();
    }

    public boolean putSettings(Object settingsTypeValue) {
        if (this.isValidSettings(settingsTypeValue)) {
            EnumMap<ConcurrencySettingsEnum, Integer> currentCurrencySettings = new EnumMap<ConcurrencySettingsEnum, Integer>(this.getSettings());
            currentCurrencySettings.putAll((Map<ConcurrencySettingsEnum, Integer>)settingsTypeValue);
            settingsTypeValue = currentCurrencySettings;
        }
        return this.putSettingsObject(settingsTypeValue);
    }

    protected boolean isValidSettings(Object settingsObj) {
        Map concurrencyMap = (Map)settingsObj;
        return concurrencyMap != null && !concurrencyMap.isEmpty();
    }

    public Object mapStringToObject(String concurrencyMap) {
        return Jsons.readValue(concurrencyMap, MAP_TYPE_REFERENCE);
    }

    protected Map<ConcurrencySettingsEnum, Integer> getDefaultPluginSettings() {
        ConcurrencyOverrideGroup overrideGroup = new ConcurrencyOverrideGroup(Arrays.asList(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX, ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX, ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX, ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX, ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX, ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX, ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX, ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX), this.darkFeaturesManager.getClusterConcurrencyOverrideValues());
        return ConcurrencySettingsEnum.getEffectiveMapWithOverrides(overrideGroup);
    }

    private Integer getConcurrencySettingsValue(ConcurrencySettingsEnum concurrencySettingsEnum) {
        return Optional.ofNullable(this.getSettings().get((Object)concurrencySettingsEnum)).orElse(concurrencySettingsEnum.getDefaultConcurrency());
    }

    public int getSpaceUsersMigrationExecutorConcurrencyClusterMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX);
    }

    public int getSpaceUsersMigrationConcurrencyNodeMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX);
    }

    public int getAttachmentMigrationConcurrencyClusterMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX);
    }

    public int getAttachmentMigrationConcurrencyNodeMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX);
    }

    public Integer getExportConcurrencyNodeMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX);
    }

    public Integer getExportConcurrencyClusterMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX);
    }

    public Integer getUploadConcurrencyClusterMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX);
    }

    public int getUploadConcurrencyNodeMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX);
    }

    public int getImportConcurrencyClusterMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX);
    }

    public int getImportConcurrencyNodeMax() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX);
    }

    public int getAttachmentUploadConcurrency() {
        return this.getConcurrencySettingsValue(ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY);
    }

    private Object getSettingsObject() {
        String settingsTypeValue = this.simpleTypeSetting.getSettingsAsString();
        if (Strings.isNullOrEmpty((String)settingsTypeValue)) {
            return this.getDefaultPluginSettings();
        }
        return this.mapStringToObject(settingsTypeValue);
    }

    private boolean putSettingsObject(Object settingsTypeValue) {
        if (this.isValidSettings(settingsTypeValue)) {
            return this.simpleTypeSetting.putChangedSettings(settingsTypeValue);
        }
        throw new IllegalArgumentException("Invalid settings for " + (Object)((Object)this.simpleTypeSetting.getMigrationSettingsType()));
    }
}

