/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.service.guardrails.macro.AbstractDatabaseMacroAssessmentSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.nbm.model.NestedBodyMacroAssessmentResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class NestedBodyMacroAssessmentSupplier
extends AbstractDatabaseMacroAssessmentSupplier<NestedBodyMacroAssessmentResult> {
    private static final String NESTED_BODY_MACRO_ASSESSMENT_NAME = "Nested Body Macro Assessment";

    public NestedBodyMacroAssessmentSupplier(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        super(tmpl, bootstrapManager);
    }

    @Override
    String getMacroAssessmentName() {
        return NESTED_BODY_MACRO_ASSESSMENT_NAME;
    }

    @Override
    String getQuery() {
        String emptyString = this.getEmptyString();
        return "select cp.content.id as id, bc.body as body from ContentProperty cp join Content c on c.id = cp.content.id join BodyContent bc ON bc.contentId = c.id where c.previousVersion is null and cp.name = 'macroNames' and c.type in ('BLOGPOST', 'PAGE') and cp.stringval IS NOT NULL and cp.stringval <> " + emptyString;
    }

    @NotNull
    private String getEmptyString() {
        ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
        String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
        return dialect.toLowerCase().contains("oracle") ? "' '" : "''";
    }

    @Override
    Stream<NestedBodyMacroAssessmentResult> map(Tuple tuple) {
        HashMap<String, NestedBodyMacroAssessmentResult> macroMap = new HashMap<String, NestedBodyMacroAssessmentResult>();
        Long contentId = (Long)tuple.get(0, Long.class);
        String body = (String)tuple.get(1, String.class);
        List<List<String>> macroPaths = this.extractAllMacroPaths(body);
        for (List<String> currentPath : macroPaths) {
            if (currentPath.size() <= 1) continue;
            String key = NestedBodyMacroAssessmentResult.createKey(currentPath);
            macroMap.computeIfAbsent(key, k -> new NestedBodyMacroAssessmentResult(currentPath, 0L, new HashSet<Long>())).updateOccurrenceAndPageIds(contentId);
        }
        return macroMap.values().stream();
    }

    private List<List<String>> extractAllMacroPaths(String body) {
        List<Element> topLevelMacros = this.getTopLevelMacro(body);
        ArrayList<List<String>> macroPaths = new ArrayList<List<String>>();
        for (Element macroElement : topLevelMacros) {
            this.extractMacroPathsRecursively(macroElement, new ArrayList<String>(), macroPaths);
        }
        return macroPaths;
    }

    private void extractMacroPathsRecursively(Element element, List<String> currentPath, List<List<String>> macroPaths) {
        String macroName = element.attr("ac:name");
        if (macroName == null || macroName.isEmpty()) {
            return;
        }
        currentPath.add(macroName);
        List<Element> children = this.getMacroChildren(element);
        if (children.isEmpty()) {
            macroPaths.add(new ArrayList<String>(currentPath));
        } else {
            for (Element child : children) {
                this.extractMacroPathsRecursively(child, currentPath, macroPaths);
            }
        }
        currentPath.remove(currentPath.size() - 1);
    }

    private List<Element> getTopLevelMacro(String body) {
        Elements allMacro = Jsoup.parse((String)body, (String)"", (Parser)Parser.xmlParser()).select("ac|structured-macro");
        ArrayList<Element> topLevelMacros = new ArrayList<Element>();
        for (Element macro : allMacro) {
            if (this.hasMacroParent(macro)) continue;
            topLevelMacros.add(macro);
        }
        return topLevelMacros;
    }

    private boolean hasMacroParent(Element element) {
        for (Element current = element.parent(); current != null; current = current.parent()) {
            if (!this.isMacro(current)) continue;
            return true;
        }
        return false;
    }

    private List<Element> getMacroChildren(Element macro) {
        return macro.children().stream().flatMap(this::macros).collect(Collectors.toList());
    }

    private Stream<Element> macros(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        stack.push(element);
        while (!stack.isEmpty()) {
            Element current = (Element)stack.pop();
            if (this.isMacro(current)) {
                result.add(current);
                continue;
            }
            stack.addAll((Collection<Element>)current.children());
        }
        return result.stream();
    }

    private boolean isMacro(Element element) {
        return element.tagName().equalsIgnoreCase("ac:structured-macro");
    }
}

