/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.InstanceAnalysisControl;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlTypes;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.remote.AssessmentCompletedEvent;
import com.atlassian.migration.agent.store.guardrails.InstanceAnalysisControlStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceAnalysisControlService
implements JobRunner {
    private static final Duration BROWSER_METRICS_COLLECTION_TIME = Duration.ofHours(24L);
    private static final Duration BROWSER_METRICS_COLLECTION_TIME_QUICK = Duration.ofMinutes(2L);
    static final String CLOUD_TRIGGERED = "cloudTriggered";
    static final String CONFIG_JSON = "configJson";
    private final PluginTransactionTemplate ptx;
    private final Logger log = LoggerFactory.getLogger(InstanceAnalysisControlService.class);
    static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.jira.migration.guardrails.InstanceAnalysisControlScheduler");
    static final JobId JOB_ID = JobId.of((String)"instance-analysis-control-job-id");
    private final InstanceAnalysisControlStore instanceAnalysisControlStore;
    private final SchedulerService schedulerService;
    private final MigrationDarkFeaturesManager features;
    private final EventPublisher eventPublisher;

    @Inject
    public InstanceAnalysisControlService(PluginTransactionTemplate ptx, @NotNull InstanceAnalysisControlStore instanceAnalysisControlStore, @NotNull SchedulerService schedulerService, MigrationDarkFeaturesManager features, EventPublisher eventPublisher) {
        this.ptx = ptx;
        this.instanceAnalysisControlStore = instanceAnalysisControlStore;
        this.schedulerService = schedulerService;
        this.features = features;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    void preDestroy() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        this.log.info("Instance analysis control job unregistered successfully.");
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            Optional<InstanceAnalysisControl> instAnalysisCtrl = this.instanceAnalysisControlStore.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name());
            if (instAnalysisCtrl.isPresent() && !this.instanceAnalysisControlStore.isFinished(instAnalysisCtrl.get())) {
                this.log.info("Updating end time on instance analysis control");
                Duration remainingDuration = this.calculateRemainingDuration(instAnalysisCtrl.get());
                if (remainingDuration.isZero() || remainingDuration.isNegative()) {
                    this.finishAssessmentCollection();
                }
            }
            return JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Exception e) {
            this.log.error("Failed to run instance analysis control with job id ${request.jobId}: ${e.message}", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    void finishAssessmentCollection() {
        this.ptx.write(() -> this.instanceAnalysisControlStore.completeInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name(), false));
        this.schedulerService.unscheduleJob(JOB_ID);
        this.eventPublisher.publish((Object)new AssessmentCompletedEvent(this, AssessmentCompletedEvent.AssessmentEventStatus.COMPLETED));
        this.log.info("Instance analysis control is completed. Publishing {} event to event publisher", (Object)AssessmentCompletedEvent.AssessmentEventStatus.COMPLETED);
    }

    public void cancelAssessmentCollection() {
        this.ptx.write(() -> this.instanceAnalysisControlStore.completeInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name(), true));
        this.schedulerService.unscheduleJob(JOB_ID);
        this.log.info("Instance analysis control is cancelled. Publishing {} event to event publisher", (Object)AssessmentCompletedEvent.AssessmentEventStatus.CANCELLED);
    }

    public void publishCancelEvent() {
        this.eventPublisher.publish((Object)new AssessmentCompletedEvent(this, AssessmentCompletedEvent.AssessmentEventStatus.CANCELLED));
    }

    public final void startAssessmentCollection(boolean cloudTriggered, InstanceAssessmentConfig config) throws SchedulerServiceException {
        if (config.isCollectBrowserMetrics()) {
            this.log.info("Initializing browser metrics collection, cloudTriggered: {}", (Object)cloudTriggered);
            this.ptx.write(() -> this.createInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()));
            this.scheduleAssessmentControlJob(cloudTriggered, config);
            this.log.info("Browser metrics collection started, cloudTriggered: {}", (Object)cloudTriggered);
        }
    }

    public final void scheduleAssessmentControlJob(boolean cloudTriggered, InstanceAssessmentConfig config) throws SchedulerServiceException {
        String configJson = Jsons.valueAsString(config);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)CLOUD_TRIGGERED, (Object)cloudTriggered, (Object)CONFIG_JSON, (Object)configJson)).withSchedule(Schedule.forInterval((long)TimeUnit.HOURS.toMillis(1L), (Date)Date.from(Instant.now().plus(Duration.ofHours(1L))))));
    }

    public final Optional<InstanceAnalysisControl> findInstanceAnalysisControl(@NotNull String analysisType) {
        return this.instanceAnalysisControlStore.findInstanceAnalysisControl(analysisType);
    }

    @NotNull
    public final InstanceAnalysisControl createInstanceAnalysisControl(@NotNull String analysisType) {
        return this.instanceAnalysisControlStore.createInstanceAnalysisControl(analysisType);
    }

    Duration calculateRemainingDuration(InstanceAnalysisControl instanceAnalysisControl) {
        Duration elapsed = Duration.between(Instant.ofEpochMilli(instanceAnalysisControl.getStartTimestamp()), Instant.now());
        Duration remainingDuration = this.assessmentDuration().minus(elapsed);
        if (remainingDuration.isNegative()) {
            return Duration.ZERO;
        }
        return remainingDuration;
    }

    public Duration assessmentDuration() {
        return this.features.isQuickAssessmentEnabled() ? BROWSER_METRICS_COLLECTION_TIME_QUICK : BROWSER_METRICS_COLLECTION_TIME;
    }
}

