/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;

public class PortFolioAnalyserAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public PortFolioAnalyserAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier) {
        this(analyticsEventBuilderUtil, senSupplier, Instant::now);
    }

    @VisibleForTesting
    PortFolioAnalyserAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, Supplier<Instant> instantSupplier) {
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
    }

    public EventDto buildRelationsAnalysisJobFinishedEvent(long durationMs, int numberOfNodes, int numberOfRelations) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"durationMs", (Object)durationMs);
        attributes.put((Object)"numberOfNodes", (Object)numberOfNodes);
        attributes.put((Object)"numberOfRelations", (Object)numberOfRelations);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).source("relationsAnalyser")).actionSubject("relationsAnalysisJob")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildRelationsAnalysisJobFailedEvent(long durationMs) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"durationMs", (Object)durationMs);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("failed")).sen(this.senSupplier.get())).source("relationsAnalyser")).actionSubject("relationsAnalysisJob")).withAttributes((Map)attributes.build())).build();
    }
}

