/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementUpdateRequest;
import com.atlassian.migration.agent.model.infraoptimisation.InfraOptimisationStatus;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;

public class DataMovementAnalyticsBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final SENSupplier senSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public DataMovementAnalyticsBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.senSupplier = senSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildDataMovementUpdateEvent(Plan plan, Boolean success) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"dataMovementId", (Object)plan.getDataMovementId());
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrationId", (Object)plan.getMigrationId());
        attributes.put((Object)"dataMovementStatus", (Object)DataMovementUpdateRequest.getDataMovementStatusFromExecutionStatus(plan.getProgress().getStatus()));
        attributes.put((Object)"success", (Object)success);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).source("planCompletion")).actionSubject("dataMovement", plan.getDataMovementId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildInfraOptimisationStatusEvent(String migrationId, String dataMovementId, InfraOptimisationStatus infraOptimisationStatus, String planId, Boolean success) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"dataMovementId", (Object)dataMovementId);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrationId", (Object)migrationId);
        attributes.put((Object)"infraOptimisationStatus", (Object)infraOptimisationStatus);
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"success", (Object)success);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("resourceOptimisationStatusPolling")).sen(this.senSupplier.get())).source("infraOptimisationWorkflow")).actionSubject("plan", planId)).withAttributes((Map)attributes.build())).build();
    }
}

