/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.MigrationSpaceStatus;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.service.encryption.AutowireHelper;
import com.atlassian.migration.agent.service.impl.MigrationSpaceStatusService;
import java.time.Instant;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

@Entity
@DiscriminatorValue(value="SPACE")
public class ConfluenceSpaceTask
extends AbstractSpaceTask {
    @Override
    public ConfluenceSpaceTask copy() {
        return new ConfluenceSpaceTask(this);
    }

    public ConfluenceSpaceTask() {
    }

    public ConfluenceSpaceTask(ConfluenceSpaceTask spaceTask) {
        super(spaceTask);
    }

    @Override
    public String getName() {
        return String.format("Migrate space %s", this.getSpaceKey());
    }

    @Override
    public TaskType getType() {
        return TaskType.SPACE;
    }

    @Override
    @PrePersist
    @PreUpdate
    public void onPostPersistOrUpdate() {
        if (this.shouldUpdateStatus()) {
            MigrationSpaceStatusService migrationSpaceStatusService = this.getMigrationSpaceStatusService();
            MigrationSpaceStatus migrationSpaceStatus = this.getOrCreateMigrationSpaceStatus(this);
            migrationSpaceStatusService.saveOrUpdate(migrationSpaceStatus);
            this.prevExecutionStatus = this.getProgress().getStatus();
        }
    }

    protected MigrationSpaceStatusService getMigrationSpaceStatusService() {
        return AutowireHelper.getBean(MigrationSpaceStatusService.class);
    }

    private MigrationSpaceStatus getOrCreateMigrationSpaceStatus(AbstractSpaceTask task) {
        String sk = task.getSpaceKey();
        String cloudId = task.getPlan().getCloudSite().getCloudId();
        String executionStatus = task.getProgress().getStatus().name();
        Instant lastUpdate = Instant.now();
        String planId = task.getPlan().getId();
        return new MigrationSpaceStatus(sk, cloudId, executionStatus, lastUpdate, planId);
    }
}

