/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.analytics;

import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.instrumentation.jvm.JvmMetrics;
import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.util.HashMap;
import java.util.Map;

public class PrometheusMetrics {
    private static final Map<String, Collector> collectors = new HashMap<String, Collector>();
    private static final Counter metricsRegistered = PrometheusMetrics.registerSilently(((Counter.Builder)Counter.builder().name("ccma.registered_metrics").labelNames(new String[]{"metric_name"})).build());
    private static final Counter initialisationCounter = PrometheusMetrics.registerSilently(((Counter.Builder)Counter.builder().name("ccma.prometheus_initialised").help("Number of times CCMA has been enabled")).build());

    private PrometheusMetrics() {
    }

    public static <T extends Collector> T registerSilently(T collector) {
        try {
            PrometheusRegistry.defaultRegistry.register(collector);
            collectors.put(collector.getPrometheusName(), collector);
            ((CounterDataPoint)metricsRegistered.labelValues(new String[]{collector.getPrometheusName()})).inc();
            return collector;
        }
        catch (Exception e) {
            return (T)collectors.get(collector.getPrometheusName());
        }
    }

    static {
        JvmMetrics.builder().register();
        ((CounterDataPoint)metricsRegistered.labelValues(new String[]{""})).inc(0L);
        initialisationCounter.inc();
    }
}

