/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.AttachmentCheckMetadata;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.impl.StatelessResults;
import java.util.List;

public class AttachmentStoreImpl
implements AttachmentStore {
    private static final String SPACE_KEY = "spaceKey";
    private static final String CLOUD_ID_KEY = "cloudId";
    private static final String FILTER_OUT_DELETED_CONTENT = " and attachment.status != 'deleted'";
    @VisibleForTesting
    static final String ATTACHMENTS_TO_MIGRATE_QUERY = "select attachment from Attachment attachment left join attachment.migrations m on m.cloudId=:cloudId join attachment.space s on s.key=:spaceKey where m is null or m.version <> attachment.version";
    @VisibleForTesting
    static final String ATTACHMENTS_TO_MIGRATE_QUERY_WITHOUT_DELETED_CONTENT = "select attachment from Attachment attachment left join attachment.migrations m on m.cloudId=:cloudId join attachment.space s on s.key=:spaceKey where m is null or m.version <> attachment.version".substring(0, "select attachment from Attachment attachment left join attachment.migrations m on m.cloudId=:cloudId join attachment.space s on s.key=:spaceKey where m is null or m.version <> attachment.version".indexOf("where")) + "where (m is null or m.version <> attachment.version)" + " and attachment.status != 'deleted'";
    @VisibleForTesting
    static final String ATTACHMENTS_TO_CHECK_QUERY = "select new com.atlassian.migration.agent.entity.AttachmentCheckMetadata(attachment.id, attachment.version, attachment.container.id, attachment.previousVersion, attachment.title, s.id, s.key)from Attachment attachment join attachment.space s on s.key in :spaceKeys where attachment.container is not null";
    @VisibleForTesting
    static final String ATTACHMENTS_TO_CHECK_QUERY_WITHOUT_DELETED_CONTENT = "select new com.atlassian.migration.agent.entity.AttachmentCheckMetadata(attachment.id, attachment.version, attachment.container.id, attachment.previousVersion, attachment.title, s.id, s.key)from Attachment attachment join attachment.space s on s.key in :spaceKeys where attachment.container is not null and attachment.status != 'deleted'";
    private final EntityManagerTemplate tmpl;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public AttachmentStoreImpl(EntityManagerTemplate tmpl, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.tmpl = tmpl;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @Override
    public StatelessResults<Attachment> getAttachmentsToMigrate(String cloudId, String spaceKey) {
        return this.tmpl.getStatelessResults(Attachment.class, this.migrationDarkFeaturesManager.isDeletedPagesMigrationExclusionEnabled() ? ATTACHMENTS_TO_MIGRATE_QUERY_WITHOUT_DELETED_CONTENT : ATTACHMENTS_TO_MIGRATE_QUERY, query -> query.setParameter(SPACE_KEY, (Object)spaceKey).setParameter(CLOUD_ID_KEY, (Object)cloudId));
    }

    @Override
    public long getAttachmentsToMigrateSize(String cloudId, String spaceKey) {
        String attachmentQuery = this.migrationDarkFeaturesManager.isDeletedPagesMigrationExclusionEnabled() ? ATTACHMENTS_TO_MIGRATE_QUERY_WITHOUT_DELETED_CONTENT : ATTACHMENTS_TO_MIGRATE_QUERY;
        String query = String.format("select sum(property.longval) from ContentProperty property where property.content in (%s) and property.name = 'FILESIZE'", attachmentQuery);
        Long size = this.tmpl.query(Long.class, query).param(SPACE_KEY, (Object)spaceKey).param(CLOUD_ID_KEY, (Object)cloudId).single();
        return size == null ? 0L : size;
    }

    @Override
    public long countAttachmentsBySpaceKey(String spaceKey) {
        Long size;
        String query = "select count(attachment) from Attachment attachment join attachment.space s on s.key=:spaceKey";
        if (this.migrationDarkFeaturesManager.isDeletedPagesMigrationExclusionEnabled()) {
            query = query + " where attachment.status != 'deleted'";
        }
        return (size = this.tmpl.query(Long.class, query).param(SPACE_KEY, (Object)spaceKey).single()) == null ? 0L : size;
    }

    @Override
    public StatelessResults<AttachmentCheckMetadata> getAttachmentsToCheck(List<String> spaceKeys) {
        return this.tmpl.getStatelessResults(AttachmentCheckMetadata.class, this.migrationDarkFeaturesManager.isDeletedPagesMigrationExclusionEnabled() ? ATTACHMENTS_TO_CHECK_QUERY_WITHOUT_DELETED_CONTENT : ATTACHMENTS_TO_CHECK_QUERY, query -> query.setParameter("spaceKeys", (Object)spaceKeys));
    }
}

