/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.service.impl.ConcurrencyLimitItem;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV2Limits;

public class ConcurrencyV4Limits
implements ConcurrencyLimits {
    private static final int MINIMUM_THRESHOLD = 1;
    private static final int MINIMUM_ATTACHMENT_THRESHOLD = 5;
    public static final int DEFAULT_ATTACHMENT_MIGRATION_CONCURRENCY = 2;
    public static final int DEFAULT_UPLOAD_CONCURRENCY = 4;
    public static final int DEFAULT_IMPORT_CONCURRENCY = 2;
    public static final int DEFAULT_EXPORT_CONCURRENCY = 2;
    private final ConcurrencyLimits template = new ConcurrencyV2Limits();
    private final int numOfNodes;

    public ConcurrencyV4Limits(int numOfNodes) {
        this.numOfNodes = numOfNodes;
    }

    @Override
    public ConcurrencyLimitItem getAttachmentClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 2 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getAttachmentNodeMaxLimit() {
        return new ConcurrencyLimitItem(5, Math.max(this.numOfNodes, 5));
    }

    @Override
    public ConcurrencyLimitItem getExportNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 2);
    }

    @Override
    public ConcurrencyLimitItem getExportClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 2 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getSpaceUsersMaxLimit() {
        return new ConcurrencyLimitItem(1, 1);
    }

    @Override
    public ConcurrencyLimitItem getSpaceUsersNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 1);
    }

    @Override
    public ConcurrencyLimitItem getUploadClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 4 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getUploadNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 4);
    }

    @Override
    public ConcurrencyLimitItem getImportClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 2 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getImportNodeMaxLimit() {
        return this.template.getImportNodeMaxLimit();
    }
}

