/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.Tracker;
import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentDataProvider;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationUploadStatus;
import org.slf4j.Logger;

public class AttachmentMigrator {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentMigrator.class);
    private static final long MAXIMUM_FILE_SIZE = 0x50000000000L;
    private final AttachmentService attachmentService;
    private final MediaFileUploaderFactory mediaFileUploaderFactory;
    private final AttachmentDataProvider attachmentDataProvider;
    private final V4Logger v4Logger;

    public AttachmentMigrator(AttachmentService attachmentService, MediaFileUploaderFactory mediaFileUploaderFactory, AttachmentDataProvider attachmentDataProvider, V4Logger v4Logger) {
        this.attachmentService = attachmentService;
        this.mediaFileUploaderFactory = mediaFileUploaderFactory;
        this.attachmentDataProvider = attachmentDataProvider;
        this.v4Logger = v4Logger;
    }

    public AttachmentMigrationUploadStatus migrate(Attachment attachment, CloudSite cloudSite, Tracker uploadTracker) {
        boolean uploaded = this.upload(attachment, cloudSite, uploadTracker);
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("attachmentId", attachment.getId(), "cloudId", cloudSite.getCloudId(), "uploadStatus", uploaded ? "UPLOAD_SUCCESS" : "UPLOAD_FAILED");
        this.v4Logger.logInfo(log, logContext, "Attachment Migration Upload Status");
        if (uploaded) {
            return AttachmentMigrationUploadStatus.UPLOAD_SUCCESS;
        }
        return AttachmentMigrationUploadStatus.UPLOAD_FAILED;
    }

    private boolean upload(Attachment attachment, CloudSite cloudSite, Tracker progressTracker) {
        return LoggingContextBuilder.logCtx().withAttachment(attachment).execute(() -> this.uploadImpl(attachment, cloudSite, progressTracker));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uploadImpl(Attachment attachment, CloudSite cloudSite, Tracker uploadTracker) {
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("attachmentId", attachment.getId(), "cloudId", cloudSite.getCloudId());
        this.v4Logger.logInfo(log, logContext, "Start upload of attachment");
        MediaFileUploader mediaFileUploader = this.mediaFileUploaderFactory.create(cloudSite.getCloudId());
        long attachmentId = attachment.getId();
        try (AttachmentDataProvider.AttachmentData attachmentData = this.attachmentDataProvider.getAttachmentData(attachmentId);){
            if (attachmentData.fileSize > 0x50000000000L) {
                this.v4Logger.logError(log, logContext, "Single file attachment size should not be larger than 5TB", null);
                this.attachmentService.logFailedAttachmentMigration(cloudSite, attachment);
                boolean bl = false;
                return bl;
            }
            String mediaId = mediaFileUploader.upload(attachmentData.inputStream, attachmentData.fileName, uploadTracker, attachmentData.fileSize);
            logContext.addAdditionalProperties("mediaId", mediaId, "fileName", attachmentData.fileName);
            this.v4Logger.logDebug(log, logContext, "Attachment Uploaded");
            this.attachmentService.logSuccessfulAttachmentMigration(cloudSite, attachment, mediaId);
            boolean bl = true;
            return bl;
        }
        catch (AttachmentDataProvider.AttachmentDataRetrievalException ex) {
            this.v4Logger.logWarn(log, logContext, "Failed to read attachment data. The error is unrecoverable. The attachment will be marked as broken and will not be retried", ex);
            this.attachmentService.logFailedAttachmentMigration(cloudSite, attachment);
            return false;
        }
    }
}

