/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.usage.DailyUsageMetricsStore;
import com.atlassian.migration.agent.service.guardrails.usage.DailyUsageSummary;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class UsageMetricsOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private final DailyUsageMetricsStore dailyUsageMetricsStore;
    private final OutputPathGenerator outputPathGenerator;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            List<DailyUsageSummary> summaries = example ? this.dailyUsageMetricsStore.listExampleSummaries(today) : this.dailyUsageMetricsStore.listSummaries(today);
            HashSet<Path> paths = new HashSet<Path>();
            if (summaries.isEmpty()) {
                return Collections.emptySet();
            }
            paths.add(this.dailyUsageMetricsStore.createDailyUsageMetricsCsv(this.outputPathGenerator.csvFilePath(OutputFilenames.USAGE_METRICS.getFilename(date)), instanceMetadataDto, summaries));
            paths.add(this.dailyUsageMetricsStore.createPageTrafficDistributionCsv(this.outputPathGenerator.csvFilePath(OutputFilenames.TRAFFIC_DISTRIBUTION.getFilename(date)), instanceMetadataDto, summaries));
            return Collections.unmodifiableSet(paths);
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    @Override
    public Boolean shouldInclude(InstanceAssessmentConfig config) {
        return config.isCollectUsageMetrics();
    }

    @Generated
    public UsageMetricsOutputFileGenerator(DailyUsageMetricsStore dailyUsageMetricsStore, OutputPathGenerator outputPathGenerator) {
        this.dailyUsageMetricsStore = dailyUsageMetricsStore;
        this.outputPathGenerator = outputPathGenerator;
    }
}

