/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.dto.ScanSummaryDto;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingConfigDTO;
import com.atlassian.migration.udc.scan.UserBaseScanService;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public class ScanSummaryService {
    private final UserBaseScanService udcBaseScanService;
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;

    public ScanSummaryService(UserBaseScanService udcBaseScanService, GlobalEmailFixesConfigService globalEmailFixesConfigService) {
        this.udcBaseScanService = udcBaseScanService;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
    }

    public ScanSummaryDto getScanSummary() {
        UserBaseScan latestScan = this.udcBaseScanService.findLatestOrGivenScanWitStatusRefreshed(null);
        DuplicateEmailsConfigDto duplicateEmailsConfig = this.globalEmailFixesConfigService.getDuplicateEmailsConfig();
        InvalidEmailsConfigDto invalidEmailsConfig = this.globalEmailFixesConfigService.getInvalidEmailsConfig();
        UDCMode confirmedUdcModeConfig = this.globalEmailFixesConfigService.getConfirmedUdcModeConfig();
        UserMappingConfigDTO userMappingConfig = this.globalEmailFixesConfigService.getUserMappingConfig();
        if (latestScan != null) {
            return new ScanSummaryDto(latestScan.getStatus(), Instant.ofEpochMilli(latestScan.getStartedAt()), ScanSummaryService.handleEmptyFinishTime(latestScan), latestScan.getInvalidUsersCount(), latestScan.getDuplicatedUsersCount(), latestScan.getId(), duplicateEmailsConfig, invalidEmailsConfig, confirmedUdcModeConfig, userMappingConfig);
        }
        return new ScanSummaryDto(duplicateEmailsConfig, invalidEmailsConfig, confirmedUdcModeConfig, userMappingConfig);
    }

    @Nullable
    private static Instant handleEmptyFinishTime(UserBaseScan latestScan) {
        return latestScan.getFinishedAt() == 0L ? null : Instant.ofEpochMilli(latestScan.getFinishedAt());
    }
}

